/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IOrderedRelationPositioning.java#1 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.repository.enum.OrderPosition;

/**
 * A ordering positioning information for relations. <br>
 * While a <code>IOrderedRelationPosition</code> just contains the information
 * about the position type and the relation the position relates to, the <code>
 * IOrderedRelationPositioning</code> contains the information which relation
 * has which <code>IOrderedRelationPosition</code> . <br>
 * To express that relation <i>R2</i> is before <i>R2</i> (with respect to
 * common relation type and source operand), a <code>OrderedRelationPositioning
 * </code> would look like <code>getRelationID()="R2"</code> with <code>
 * getPosotion().getType()=OrderPosition.BEFORE</code> and <code>
 * getPosition().getRelativeID()="R1"</code> .
 */
public interface IOrderedRelationPositioning {

  /**
   * Get the ordering position.
   *
   * @return the <code>IOrderedRelationPosition</code> for this position.
   */
  public IOrderedRelationPosition getPosition();


  /**
   * Get the ordering position relative the position type refers to.
   *
   * @return the <code>String</code> with the id of the relation
   */
  public String getRelationID();

}
