/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IOrderedRelationPosition.java#1 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.repository.enum.OrderPosition;

/**
 * An ordering position for relations. <br>
 * Let's assume the relations <i>R1</i> and <i>R2</i> belong to the same
 * relation type <i>T</i> and they both have the same source operand <i>S</i> .
 * Furthermore <i>R1</i> has <i>T1</i> as target operand while <i>R2</i> has <i>
 * T2</i> as target operand. To express that relation <i>R2</i> should be before
 * <i>R2</i> (with respect to their common type and source operand), the <code>
 * OrderedRelationPosition</code> for <i>R2</i> would look like <code>
 * getPosition()=OrderPosition.BEFORE</code> and <code>
 * getRelativeRelationID()="R1"</code> , while the <code>OrderedRelationPosition
 * </code> for <i>R1</i> would look like <code>getPosition()=OrderPosition.AFTER
 * </code> and <code>getRelativeRelationID()="R2"</code> .
 */
public interface IOrderedRelationPosition {

  /**
   * Get the ordering position type.
   *
   * @return the <code>OrderPosition</code> for this position.
   */
  public OrderPosition getType();


  /**
   * Get the id of the relation to which this position relates to.
   *
   * @return the <code>String</code> with the id of the related relation. Can be
   *      <code>null</code> if <code>getType()</code> is <code>
   *      OrderPosition.FIRST</code> or <code>OrderPosition.LAST</code> .
   */
  public String getRelativeID();

}
