/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/AbstractRelationWatcher.java#2 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.repository.IProperty;
import com.sapportals.wcm.repository.IPropertyName;

/**
 * A basic implementation for a <code>IRelationWatcher</code> . <br>
 *
 */
public class AbstractRelationWatcher
   implements IRelationWatcher {

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  /**
   * The relation watcher's unique id.
   */
  protected String id;

  /**
   * flag to indicate that this watcher want's to be called when a relation was
   * created.
   */
  protected boolean isCreateWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation is
   * to be deleted.
   */
  protected boolean isDeleteWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a property was
   * set for a relation.
   */
  protected boolean isPropertySetWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a property was
   * deleted from a relation.
   */
  protected boolean isPropertyDeleteWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * source operand changed.
   */
  protected boolean isSourceChangeWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * target operand changed.
   */
  protected boolean isTargetChangeWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * source operand was deleted.
   */
  protected boolean isSourceDeleteWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * target operand was deleted.
   */
  protected boolean isTargetDeleteWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * source operand was copied.
   */
  protected boolean isSourceCopyWatcher = false;

  /**
   * flag to indicate that this watcher want's to be called when a relation's
   * target operand was copied.
   */
  protected boolean isTargetCopyWatcher = false;


  // ------------
  // Constructors ---------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  /**
   * Create a relation watcher for a given id, which does nothing.
   *
   * @param id a <code>String</code> with the id for this watcher. if <code>null
   *      </code>, the classname is used.
   */
  protected AbstractRelationWatcher(String id) {

    if (id == null) {
      id = this.getClass().getName();
    }

    this.id = id;

  }


  // ------
  // Object -------------------------------------------------------------------
  // ------

  // ------------------------------------------------------------------------
  /**
   * Compare two <code>IRelationWatcher</code> s for equality. Two watchers are
   * considered equal if they have the same id (as returned by {@link IRelationWatcher#getID()}.
   *
   * @param object the <code>Object</code> to compare with this one.
   * @return <code>true</code> if this watcher has the same id a the other
   *      watcher referenced by the given object.
   */
  public boolean equals(Object object) {

    if (object == null) {
      return false;
    }

    if (object instanceof AbstractRelationWatcher) {
      AbstractRelationWatcher other = (AbstractRelationWatcher)object;
      return (this.id.equals(other.id));
    }

    if (object instanceof IRelationWatcher) {
      IRelationWatcher other = (IRelationWatcher)object;
      return (this.id.equals(other.getID()));
    }

    return false;
  }


  // ----------------
  // IRelationWatcher ---------------------------------------------------------
  // ----------------

  // ------------------------------------------------------------------------
  public String getID() {

    return this.id;
  }


  // ------------------------------------------------------------------------
  public boolean isCreateWatcher() {

    return this.isCreateWatcher;
  }


  // ------------------------------------------------------------------------
  public void onCreate(IRelation relation) { }


  // ------------------------------------------------------------------------
  public boolean isDeleteWatcher() {

    return this.isDeleteWatcher;
  }


  // ------------------------------------------------------------------------
  public void onDelete(IRelation relation) { }


  // ------------------------------------------------------------------------
  public boolean isPropertySetWatcher() {

    return this.isPropertySetWatcher;
  }


  // ------------------------------------------------------------------------
  public void onPropertySet(IRelation relation,
    IProperty setProperty) { }


  // ------------------------------------------------------------------------
  public boolean isPropertyDeleteWatcher() {

    return this.isPropertyDeleteWatcher;
  }


  // ------------------------------------------------------------------------
  public void onPropertyDelete(IRelation relation,
    IPropertyName deletedProperty) { }


  // ------------------------------------------------------------------------
  public boolean isSourceChangeWatcher() {

    return this.isSourceChangeWatcher;
  }


  // ------------------------------------------------------------------------
  public void onSourceChange(IRelation relation,
    String oldSourceId,
    String newSourceId) { }


  // ------------------------------------------------------------------------
  public boolean isTargetChangeWatcher() {

    return this.isTargetChangeWatcher;
  }


  // ------------------------------------------------------------------------
  public void onTargetChange(IRelation relation,
    String oldTargetId,
    String newSourceId) { }


  // ------------------------------------------------------------------------
  public boolean isSourceDeleteWatcher() {

    return this.isSourceDeleteWatcher;
  }


  // ------------------------------------------------------------------------
  public void onSourceDelete(IRelation relation) { }


  // ------------------------------------------------------------------------
  public void onSourceChangeDelete(IRelation relation,
    String oldSourceId) { }


  // ------------------------------------------------------------------------
  public boolean isTargetDeleteWatcher() {

    return this.isTargetDeleteWatcher;
  }


  // ------------------------------------------------------------------------
  public void onTargetDelete(IRelation relation) { }


  // ------------------------------------------------------------------------
  public void onTargetChangeDelete(IRelation relation,
    String oldTargetId) { }


  // ------------------------------------------------------------------------
  public boolean isSourceCopyWatcher() {

    return this.isSourceCopyWatcher;
  }


  // ------------------------------------------------------------------------
  public void onSourceCopy(IRelation relation,
    IRelation originalRelation) { }


  // ------------------------------------------------------------------------
  public boolean isTargetCopyWatcher() {

    return this.isTargetCopyWatcher;
  }


  // ------------------------------------------------------------------------
  public void onTargetCopy(IRelation relation,
    IRelation originalRelation) { }

}
