package temp.persistence.gettingstarted.web;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import temp.persistence.gettingstarted.dao.DAO;
import temp.persistence.gettingstarted.dao.EmployeeData;

public class ProcessInput extends HttpServlet {
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		DAO dao = null;
		PrintWriter out = response.getWriter();
		try {
			out.println("<html><body>");
			String action = request.getParameter("ACTION");
			int depId = Integer.parseInt(request.getParameter("DEPID"));
			String daoType = request.getParameter("DAO");
			if (daoType.equals("SQLJ")) {
				dao = (DAO) Class.forName("temp.persistence.gettingstarted.dao.SqljDAO").newInstance();
				out.println("<h4>Using SQLJ</h4>");
			} else {
				dao = (DAO) Class.forName("temp.persistence.gettingstarted.dao.JdbcDAO").newInstance();
				out.println("<h4>Using JDBC</h4>");
			}
			try {
				if (action.equals("NEW_DEP")) {
					String depName = request.getParameter("NAME");
					dao.createDepartment(depId, depName);
					dao.commit();
					out.println("Department \"" + depName + "\" created.");
				} else if (action.equals("NEW_EMP")) {
					int empId = Integer.parseInt(request.getParameter("EMPID"));
					String firstName = request.getParameter("FIRST_NAME");
					String lastName = request.getParameter("LAST_NAME");
					BigDecimal salary =	new BigDecimal(request.getParameter("SALARY"));
					EmployeeData data = new EmployeeData(empId, firstName, lastName, salary, depId);
					dao.createEmployee(data);
					out.println(
						"Employee \""
						+ firstName
						+ " "
						+ lastName
						+ "\" created.");
					dao.commit();
				} else if (action.equals("LIST")) {
					EmployeeData[] emps = dao.getEmployeesFromDepartment(depId);
					if (emps.length == 0) {
						out.println("<br>no data");
					} else {
						out.println("<table><tr>");
						out.println("<td>Employee ID</td>");
						out.println("<td>First Name</td>");
						out.println("<td>Last Name</td>");
						out.println("<td>Salary</td>");
						out.println("<td>Department ID</td></tr>");
						for (int i = 0; i < emps.length; i++) {
							out.println("<tr>");
							out.println("<td>" + emps[i].getEmpId() + "</td>");
							out.println("<td>" + emps[i].getFirstName() + "</td>");
							out.println("<td>" + emps[i].getLastName() + "</td>");
							out.println("<td>" + emps[i].getSalary() + "</td>");
							out.println("<td>" + emps[i].getDepId() + "</td>");
							out.println("</tr>");
						}
						out.println("</table>");
					}
				} else {
					out.println("Illegal action: " + action);
				}
			} finally {
				dao.close();
			}
		} catch (Throwable ex) {
			out.println("Exception caught");
			out.println("<code>");
			ex.printStackTrace(out);
			out.println("</code>");
		} finally {
			out.println("<p><a href=index.html>Home</a></p>");
			out.println("</body></html>");
		}
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response)	throws ServletException, IOException {
		doGet(request, response);
	}
}