package temp.persistence.gettingstarted.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;


public class JdbcDAO implements DAO {

	Connection conn;

	public JdbcDAO() throws SQLException {
		// obtain a database connection using a DataSource
		try {
			InitialContext ctx = new InitialContext();
			DataSource dataSource = (DataSource) ctx.lookup("java:comp/env/TMP_PERSISTENCE_EXAMPLE");
			conn = dataSource.getConnection();
			if (conn == null) {
				throw new SQLException("conn == null");
			}
			conn.setAutoCommit(false);
		} catch (NamingException ex) {
			throw new SQLException("NamingException: " + ex.getMessage());
		}
	}

	public void createDepartment(int depId, String depName)	throws SQLException {
		PreparedStatement stmt = conn.prepareStatement("insert into TMP_DEPARTMENT (DEPID, NAME) values (?, ?)");
		try {
			stmt.setInt(1, depId);
			stmt.setString(2, depName);
			stmt.executeUpdate();
		} finally {
			stmt.close();
		}
	}

	public void createEmployee(EmployeeData employee) throws SQLException {
		PreparedStatement stmt =conn.prepareStatement(
			"insert into TMP_EMPLOYEE (EMPID, FIRST_NAME, LAST_NAME, SALARY, DEPID) "
			+ "values (?, ?, ?, ?, ?)");
		try {
			stmt.setInt(1, employee.getEmpId());
			stmt.setString(2, employee.getFirstName());
			stmt.setString(3, employee.getLastName());
			stmt.setBigDecimal(4, employee.getSalary());
			stmt.setInt(5, employee.getDepId());
			stmt.executeUpdate();
		} finally {
			stmt.close();
		}
	}

	public EmployeeData[] getEmployeesFromDepartment(int depId)	throws SQLException {
		ArrayList list = new ArrayList();
		PreparedStatement stmt = conn.prepareStatement(
			"select EMPID, FIRST_NAME, LAST_NAME, SALARY "
			+ "from TMP_EMPLOYEE "
			+ "where DEPID = ?");
		try {
			stmt.setInt(1, depId);
			ResultSet rs = stmt.executeQuery();
			try {
				while (rs.next()) {
					EmployeeData data =	new EmployeeData(
						rs.getInt(1),
						rs.getString(2),
						rs.getString(3),
						rs.getBigDecimal(4),
						depId);
					list.add(data);
				}
			} finally {
				rs.close();
			}
			return (EmployeeData[]) list.toArray(new EmployeeData[] {
			});
		} finally {
			stmt.close();
		}
	}

	// commits the work
	public void commit() throws SQLException {
		conn.commit();
	}

	// rolls back the work
	public void rollback() throws SQLException {
		conn.rollback();
	}

	// closes the connection
	public void close() throws SQLException {
		if (conn != null) conn.close();
	}
}