/*@lineinfo:filename=SqljDAO*//*@lineinfo:user-code*//*@lineinfo:1^1*/package temp.persistence.gettingstarted.dao;

import java.util.ArrayList;
import java.sql.SQLException;

public class SqljDAO implements DAO {

	Ctx ctx;
	
	public SqljDAO() throws SQLException {
		ctx = new Ctx();
		if (ctx == null) {
			throw new SQLException("ctx == null");
		}
		ctx.getConnection().setAutoCommit(false);
	}

	public void createDepartment(int depId, String depName) throws SQLException {
		/*@lineinfo:generated-code*//*@lineinfo:19^2*/

//  ************************************************************
//  #sql [ctx] { insert into TMP_DEPARTMENT (DEPID, NAME) values (:depId, :depName)  };
//  ************************************************************

{
  java.lang.Object __sJT_sqlStmt = SqljDAO_SJStatements.getSqlStatement(ctx, 0);
  sqlj.runtime.ConnectionContext __sJT_dummyCtx = com.sap.sql.sqlj.common.runtime.ConnectionContextFactory.createFakeContext(ctx, __sJT_sqlStmt);
  sqlj.runtime.ExecutionContext __sJT_execCtx = ctx.getExecutionContext();
  int __sJT_1 = depId;
  String __sJT_2 = depName;
  sqlj.runtime.profile.RTStatement __sJT_stmt = __sJT_execCtx.registerStatement(__sJT_dummyCtx, null, 0);
  try 
  {
    __sJT_stmt.setInt(1, __sJT_1);
    __sJT_stmt.setString(2, __sJT_2);
    __sJT_execCtx.executeUpdate();
  }
  finally 
  {
    __sJT_execCtx.releaseStatement();
  }
}


//  ************************************************************

/*@lineinfo:user-code*//*@lineinfo:19^82*/
	}

	public void createEmployee(EmployeeData employee) throws SQLException {
		/*@lineinfo:generated-code*//*@lineinfo:23^2*/

//  ************************************************************
//  #sql [ctx] { insert into TMP_EMPLOYEE (EMPID, FIRST_NAME, LAST_NAME, SALARY, DEPID) 
//  			values (:employee.getEmpId(), 
//  					:employee.getFirstName(), 
//  					:employee.getLastName(), 
//  					:employee.getSalary(), 
//  					:employee.getDepId())  };
//  ************************************************************

{
  java.lang.Object __sJT_sqlStmt = SqljDAO_SJStatements.getSqlStatement(ctx, 1);
  sqlj.runtime.ConnectionContext __sJT_dummyCtx = com.sap.sql.sqlj.common.runtime.ConnectionContextFactory.createFakeContext(ctx, __sJT_sqlStmt);
  sqlj.runtime.ExecutionContext __sJT_execCtx = ctx.getExecutionContext();
  int __sJT_1 = employee.getEmpId();
  String __sJT_2 = employee.getFirstName();
  String __sJT_3 = employee.getLastName();
  java.math.BigDecimal __sJT_4 = employee.getSalary();
  int __sJT_5 = employee.getDepId();
  sqlj.runtime.profile.RTStatement __sJT_stmt = __sJT_execCtx.registerStatement(__sJT_dummyCtx, null, 0);
  try 
  {
    __sJT_stmt.setInt(1, __sJT_1);
    __sJT_stmt.setString(2, __sJT_2);
    __sJT_stmt.setString(3, __sJT_3);
    __sJT_stmt.setBigDecimal(4, __sJT_4);
    __sJT_stmt.setInt(5, __sJT_5);
    __sJT_execCtx.executeUpdate();
  }
  finally 
  {
    __sJT_execCtx.releaseStatement();
  }
}


//  ************************************************************

/*@lineinfo:user-code*//*@lineinfo:28^29*/ 
	}

	public EmployeeData[] getEmployeesFromDepartment(int depId) throws SQLException {
		EmployeeIter iter = null;
		ArrayList list = new ArrayList();
		/*@lineinfo:generated-code*//*@lineinfo:34^2*/

//  ************************************************************
//  #sql [ctx] iter = { select EMPID, FIRST_NAME, LAST_NAME, SALARY from TMP_EMPLOYEE 
//  			where DEPID = :depId  };
//  ************************************************************

{
  java.lang.Object __sJT_sqlStmt = SqljDAO_SJStatements.getSqlStatement(ctx, 2);
  sqlj.runtime.ConnectionContext __sJT_dummyCtx = com.sap.sql.sqlj.common.runtime.ConnectionContextFactory.createFakeContext(ctx, __sJT_sqlStmt);
  sqlj.runtime.ExecutionContext __sJT_execCtx = ctx.getExecutionContext();
  int __sJT_1 = depId;
  sqlj.runtime.profile.RTStatement __sJT_stmt = __sJT_execCtx.registerStatement(__sJT_dummyCtx, null, 0);
  try 
  {
    __sJT_stmt.setInt(1, __sJT_1);
    sqlj.runtime.profile.RTResultSet __sJT_result = __sJT_execCtx.executeQuery();
    iter = new EmployeeIter(__sJT_result);
  }
  finally 
  {
    __sJT_execCtx.releaseStatement();
  }
}


//  ************************************************************

/*@lineinfo:user-code*//*@lineinfo:35^24*/
		while (iter.next()) {
			EmployeeData data = new EmployeeData(iter.EMPID(), 
				iter.FIRST_NAME(), 
				iter.LAST_NAME(), 
				iter.SALARY(), 
				depId);
			list.add(data); 
		}
		return (EmployeeData[])list.toArray(new EmployeeData[] {});
	}


	// commits the work
	public void commit() throws SQLException {
		/*@lineinfo:generated-code*//*@lineinfo:50^2*/

//  ************************************************************
//  #sql [ctx] { commit work  };
//  ************************************************************

{
  ctx.getConnection().commit();
}


//  ************************************************************

/*@lineinfo:user-code*//*@lineinfo:50^27*/
	}

	// rolls back the work
	public void rollback() throws SQLException {
		/*@lineinfo:generated-code*//*@lineinfo:55^2*/

//  ************************************************************
//  #sql [ctx] { rollback work  };
//  ************************************************************

{
  ctx.getConnection().rollback();
}


//  ************************************************************

/*@lineinfo:user-code*//*@lineinfo:55^29*/
	}

	// closes the connection
	public void close() throws SQLException {
		if (ctx != null) ctx.close();
	}
}/*@lineinfo:generated-code*/class SqljDAO_SJStatements 
{
  private static java.lang.String[] stmtText = new java.lang.String[]  {
    "insert into TMP_DEPARTMENT (DEPID, NAME) values ( ? ,  ? ) ",
    "insert into TMP_EMPLOYEE (EMPID, FIRST_NAME, LAST_NAME, SALARY, DEPID) \n\t\t\tvalues ( ? , \n\t\t\t\t\t ? , \n\t\t\t\t\t ? , \n\t\t\t\t\t ? , \n\t\t\t\t\t ? ) ",
    "select EMPID, FIRST_NAME, LAST_NAME, SALARY from TMP_EMPLOYEE \n\t\t\twhere DEPID =  ?  "
  };
  private static java.lang.Object[] sqlStatement = new java.lang.Object[]  {
    null,
    null,
    null
  };
  private static int[] sourceLine = new int[]  {
    19,
    23,
    34
  };
  public static final java.lang.String source = "SqljDAO.sqlj";
  public static final long timestamp = 1075291158344l;
  public static java.lang.Object getSqlStatement(sqlj.runtime.ConnectionContext context, int stmtNum) 
    throws java.sql.SQLException 
  {
    synchronized (sqlStatement) {
      if (sqlStatement[stmtNum] == null)
      {
        sqlStatement[stmtNum] = com.sap.sql.sqlj.common.runtime.StatementAnalyzer.preprepareStatement(context, stmtText[stmtNum], source, sourceLine[stmtNum], timestamp);
      }
    }
    return sqlStatement[stmtNum];
  }
}
