<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xalan/java" xmlns:redirect="http://xml.apache.org/xalan/redirect" xmlns:IDX="urn:sap.com:DevelopmentComponent:1.0" xmlns="http://xml.sap.com/2002/11/DevelopmentComponent" xmlns:eclipse="urn:eclipse.org" extension-element-prefixes="redirect java">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="parPlugInDir" select="'/'"/>
	<!-- absolute path to the plugin or fragment dir, parameter with trailing slash -->
	<xsl:param name="parDCDir" select="'/'"/>
	<!-- absolute path to the _comp folder of the current dc, with trailing slash -->
	<xsl:param name="parEclipseDir" select="/"/>
	<!-- absolute path to the eclipse installation folder, with trailing slash -->
	<xsl:variable name="varPackageFolders" select="java:com.sap.bi.ext.eclipse.ExtractBuildProperties.extractPackageFolders($parPlugInDir)"/>
	<!-- Entry point for fragment handling -->
	<xsl:template match="fragment">
		<xsl:variable name="varName" select="string(@name)"/>
		<xsl:variable name="varProviderName" select="string(@provider-name)"/>
		<xsl:variable name="varFragmentId" select="@id"/>
		<xsl:variable name="varDCName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID($varFragmentId)"/>
		<xsl:variable name="varParentPluginDCName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID(@plugin-id)"/>
		<xsl:variable name="varParentPluginDir" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getMatchingPluginDir($parEclipseDir,@plugin-id,@plugin-version,@match)"/>
		<xsl:variable name="varDebug" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.debug(.)"/>				
		<xsl:variable name="varParentPluginXML" select="document(concat($varParentPluginDir,'/plugin.xml'))"/>
		<xsl:variable name="varListOfPluginRelativeLibraryPaths" select="$varParentPluginXML//library/@name"/>
		<xsl:element name="development-component">
			<xsl:attribute name="version">1.0</xsl:attribute>
			<name>
				<xsl:value-of select="$varDCName"/>
			</name>
			<vendor>sap.com</vendor>
			<caption>
				<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($parPlugInDir, $varParentPluginDir, $varName)"/>
			</caption>
			<description>
				<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($parPlugInDir, $varParentPluginDir, $varName)"/>
			</description>
			<component-type>
				<vendor>sap.com</vendor>
				<type>Eclipse Fragment</type>
			</component-type>
			<properties>
				<!-- Save the fragement id to ensure that the id can be recovered from the .dcdef definition -->
				<eclipse:fragment-id>
					<xsl:value-of select="@id"/>
				</eclipse:fragment-id>
				<eclipse:fragment-version>
					<xsl:value-of select="@version"/>
				</eclipse:fragment-version>
				<eclipse:plugin-id>
					<xsl:value-of select="@plugin-id"/>
				</eclipse:plugin-id>
				<eclipse:plugin-version>
					<xsl:value-of select="@plugin-version"/>
				</eclipse:plugin-version>
				<eclipse:match>
					<xsl:value-of select="@match"/>
				</eclipse:match>
			</properties>
			<!-- no source so we are external -->
			<xsl:if test="not($varPackageFolders)">
				<external/>
			</xsl:if>
			<!-- sources so we are not external and need a build plugin -->			
			<xsl:if test="$varPackageFolders">
				<build-plugin>
					<dc-ref>
						<name>tc/bi/bp/eclipse</name>
						<vendor>sap.com</vendor>
					</dc-ref>
					<pp-ref>def</pp-ref>
				</build-plugin>
			</xsl:if>
			<!--  When traversing "requires" elements add a dependency to the plugin! -->
			<xsl:if test="not(boolean(requires))">
				<!-- There is no requires element so we have to add the dependency here -->
				<xsl:element name="dependencies">
					<xsl:call-template name="parentPluginDependencies">
						<xsl:with-param name="varListOfPluginRelativeLibraryPaths">
							<xsl:value-of select="$varListOfPluginRelativeLibraryPaths"/>
						</xsl:with-param>
						<xsl:with-param name="varParentPluginDCName">
							<xsl:value-of select="$varParentPluginDCName"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:if>
			<xsl:apply-templates>
				<xsl:with-param name="varListOfPluginRelativeLibraryPaths">
					<xsl:value-of select="$varListOfPluginRelativeLibraryPaths"/>
				</xsl:with-param>
				<xsl:with-param name="varParentPluginDCName">
					<xsl:value-of select="$varParentPluginDCName"/>
				</xsl:with-param>
			</xsl:apply-templates>
			
			<!-- Add package and source folders -->
			<xsl:if test="$varPackageFolders">
				<xsl:element name="folders">
					<xsl:call-template name="packageFolders">
						<xsl:with-param name="listOfFolders">
							<xsl:value-of select="$varPackageFolders"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	
	<!-- Called by name! Used only by fragments to produce dependencies to the parent dc-->
	<xsl:template name="parentPluginDependencies">
		<xsl:param name="varListOfPluginRelativeLibraryPaths"/>
		<xsl:param name="varParentPluginDCName"/>
		<xsl:for-each select="$varListOfPluginRelativeLibraryPaths">
			<xsl:element name="dependency">
				<xsl:element name="dc-ref">
					<name>
						<xsl:value-of select="$varParentPluginDCName"/>
					</name>
					<vendor>sap.com</vendor>
				</xsl:element>
				<xsl:element name="pp-ref">
					<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.extractJarName(.)"/>
				</xsl:element>
				<at-build-time/>
				<at-runtime/>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	
	<!-- entry point for plugin handling -->
	<xsl:template match="plugin">
		<xsl:variable name="varName" select="string(@name)"/>
		<xsl:variable name="varProviderName" select="string(@provider-name)"/>
		<xsl:variable name="varPlugInId" select="@id"/>
		<xsl:variable name="varDCName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID($varPlugInId)"/>
		<xsl:element name="development-component">
			<xsl:attribute name="version">1.0</xsl:attribute>
			<name>
				<xsl:value-of select="$varDCName"/>
			</name>
			<vendor>sap.com</vendor>
			<caption>
				<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($parPlugInDir,$varName)"/>
			</caption>
			<description>
				<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($parPlugInDir,$varName)"/>
			</description>
			<component-type>
				<vendor>sap.com</vendor>
				<type>Eclipse Plugin</type>
			</component-type>
			<properties>
				<!-- Save the plugin id to ensure that the id can be recovered from the .dcdef definition -->
				<eclipse:plugin-id>
					<xsl:value-of select="@id"/>
				</eclipse:plugin-id>
				<eclipse:plugin-version>
					<xsl:value-of select="@version"/>
				</eclipse:plugin-version>
				<eclipse:plugin-class>
					<xsl:value-of select="@class"/>
				</eclipse:plugin-class>
			</properties>
			
			<!-- no source so we are external -->
			<xsl:if test="not($varPackageFolders)">
				<external/>
			</xsl:if>
			<xsl:if test="not(boolean(requires))">
				<xsl:element name="dependencies">
					<!-- There is no requires element so we have to add the defualt dependencies here -->
					<!-- Every plugin has implict a dependency to these to pps, they are not exlicit in the plugin model but must be exlicit in the DC model-->
					<xsl:element name="dependency">
						<xsl:element name="dc-ref">
							<name>
								<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID('org.eclipse.core.runtime')"/>
							</name>
							<vendor>sap.com</vendor>
						</xsl:element>
						<xsl:element name="pp-ref">
							<xsl:value-of select="'runtime'"/>
						</xsl:element>
						<at-build-time/>
						<at-runtime/>
					</xsl:element>
					<xsl:element name="dependency">
						<xsl:element name="dc-ref">
							<name>
								<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID('org.eclipse.core.boot')"/>
							</name>
							<vendor>sap.com</vendor>
						</xsl:element>
						<xsl:element name="pp-ref">
							<xsl:value-of select="'boot'"/>
						</xsl:element>
						<at-build-time/>
						<at-runtime/>
					</xsl:element>
				</xsl:element>
			</xsl:if>
			<xsl:apply-templates/>
			
			<!-- create package folders if we have them -->
			<xsl:if test="$varPackageFolders">
				<xsl:element name="folders">
					<xsl:call-template name="packageFolders">
						<xsl:with-param name="listOfFolders">
							<xsl:value-of select="$varPackageFolders"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:if>
			
		</xsl:element>
	</xsl:template>
	<xsl:template name="packageFolders">
		<xsl:param name="listOfFolders"/>
		<xsl:variable name="folder" select="substring-before($listOfFolders,',')"/>
		<xsl:variable name="folders" select="substring-after($listOfFolders,',')"/>
		<!-- Only if got something do something-->
		<xsl:if test="$listOfFolders">
			<!-- Got actually something to recurse-->
			<xsl:if test="$folder">
				<!-- implicit test="$folders" -->
				<xsl:element name="package-folder">
					<xsl:value-of select="$folder"/>
				</xsl:element>
				<xsl:call-template name="packageFolders">
					<xsl:with-param name="listOfFolders">
						<xsl:value-of select="$folders"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<!-- done -->
			<xsl:if test="not($folder)">
				<xsl:element name="package-folder">
					<xsl:value-of select="$listOfFolders"/>
				</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Generate as much dependencies as there are exported libaries in the referenced plug-in
             plus reexported (recursive) imports of the referenced plugin.-->
	<xsl:template match="requires">
		<xsl:param name="varListOfPluginRelativeLibraryPaths"/>
		<!-- not null only for fragments-->
		<xsl:param name="varParentPluginDCName"/>
		<!-- not null only for fragments-->
		<xsl:element name="dependencies">
			<!-- Every plugin has implict a dependency to these to pps, they are not exlicit in the plugin model but must be exlicit in the DC model-->
			<xsl:element name="dependency">
				<xsl:element name="dc-ref">
					<name>
						<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID('org.eclipse.core.runtime')"/>
					</name>
					<vendor>sap.com</vendor>
				</xsl:element>
				<xsl:element name="pp-ref">
					<xsl:value-of select="'runtime'"/>
				</xsl:element>
				<at-build-time/>
				<at-runtime/>
			</xsl:element>
			<xsl:element name="dependency">
				<xsl:element name="dc-ref">
					<name>
						<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID('org.eclipse.core.boot')"/>
					</name>
					<vendor>sap.com</vendor>
				</xsl:element>
				<xsl:element name="pp-ref">
					<xsl:value-of select="'boot'"/>
				</xsl:element>
				<at-build-time/>
				<at-runtime/>
			</xsl:element>
			<xsl:if test="$varListOfPluginRelativeLibraryPaths">
				<xsl:call-template name="parentPluginDependencies">
					<xsl:with-param name="varListOfPluginRelativeLibraryPaths">
						<xsl:value-of select="$varListOfPluginRelativeLibraryPaths"/>
					</xsl:with-param>
					<xsl:with-param name="varParentPluginDCName">
						<xsl:value-of select="$varParentPluginDCName"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<!-- recurse to the imports -->
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="import">
		<xsl:variable name="varOptional" select="@optional"/>
		<xsl:variable name="varRefPlugInId" select="@plugin"/>
		<xsl:variable name="varRefDCName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID($varRefPlugInId)"/>
		<xsl:variable name="varRefVersion" select="@version"/>
		<xsl:variable name="varRefMatch" select="@match"/>
		<xsl:variable name="varRelPathToRefPlugin" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getMatchingPluginDir($parEclipseDir,$varRefPlugInId,$varRefVersion,$varRefMatch)"/>
		<xsl:if test="string-length($varOptional)=0 or ($varOptional='true' and string-length($varRelPathToRefPlugin)>0)">
			<!--<xsl:variable name="varDebug" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.debug(.)"/>-->
			<xsl:variable name="varRelPathsToRefFragments" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getMatchingFragmentDirs($varRelPathToRefPlugin)"/>
			<!-- Get plugin/plugin.xml referenced by import statement -->
			<xsl:variable name="varReferencedPluginXML" select="document(concat(string($varRelPathToRefPlugin),'plugin.xml'))"/>
			<xsl:variable name="varListOfPluginRelativeLibraryPaths" select="$varReferencedPluginXML//library/@name"/>
			<!--  <xsl:variable name="debug" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.debug(concat('varRefPlugInId: ',$varRefPlugInId,' varListOfPluginRelativeLibraryPaths: ',$varListOfPluginRelativeLibraryPaths))"/> -->
			<xsl:variable name="varProviderNameOfRefPlugin" select="$varReferencedPluginXML/plugin/@provider-name"/>
			<xsl:variable name="varProviderNameOfRefPluginExpanded" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($varRelPathToRefPlugin,$varProviderNameOfRefPlugin)"/>
			<xsl:variable name="varListOfExportedImports" select="$varReferencedPluginXML//requires/import[@export='true']"/>
			<xsl:for-each select="$varListOfPluginRelativeLibraryPaths">
				<!-- Check dependencies  for fragment contributions and retarget the dependency to the fragment -->
				<xsl:variable name="varRefDCFragementName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.extractFragmentName($parEclipseDir,$varRefPlugInId,$varRefVersion,$varRefMatch,.)"/>
				<xsl:variable name="varRefPPFragmentName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.extractFragmentPPName($parEclipseDir,$varRefPlugInId,$varRefVersion,$varRefMatch,.)"/>
				<xsl:choose>
					<xsl:when test="$varRefDCFragementName">
						<xsl:element name="dependency">
							<xsl:element name="dc-ref">
								<name>
									<xsl:value-of select="$varRefDCFragementName"/>
								</name>
								<vendor>sap.com</vendor>
							</xsl:element>
							<xsl:element name="pp-ref">
								<xsl:value-of select="$varRefPPFragmentName"/>
							</xsl:element>
							<at-build-time/>
							<at-runtime/>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="dependency">
							<xsl:element name="dc-ref">
								<name>
									<xsl:value-of select="$varRefDCName"/>
								</name>
								<vendor>sap.com</vendor>
							</xsl:element>
							<xsl:element name="pp-ref">
								<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.extractJarName(.)"/>
							</xsl:element>
							<at-build-time/>
							<at-runtime/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<!-- recurse -->
			<xsl:apply-templates select="$varListOfExportedImports"/>
		
			<!-- Handel dependecies caused by transparent fragements -->
			<xsl:if test="string-length($varRelPathsToRefFragments)>0">
				<xsl:call-template name="fragmentImport">
					<xsl:with-param name="varRelPathsToRefFragments" select="$varRelPathsToRefFragments"/>
				</xsl:call-template>
			</xsl:if>		
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="fragmentImport">
		<!-- TODO: make it work with more than one dir -->
		<xsl:param name="varRelPathsToRefFragments"/>
		<xsl:variable name="varReferencedFragmentXML" select="document(concat(string($varRelPathsToRefFragments),'fragment.xml'))"/>
		<xsl:variable name="varListOfFragmentRelativeLibraryPaths" select="$varReferencedFragmentXML//library/@name"/>
		<xsl:variable name="varRefFragmentId" select="$varReferencedFragmentXML/fragment/@id"/>
		<xsl:variable name="debug" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.debug(concat('varRefFragmentId: ',$varRefFragmentId,' varListOfFragmentRelativeLibraryPaths: ',$varListOfFragmentRelativeLibraryPaths))"/>
		<xsl:variable name="varRefDCName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getDCNameFromPluginID($varRefFragmentId)"/>
		<xsl:variable name="varProviderNameOfRefFragment" select="$varReferencedFragmentXML/plugin/@provider-name"/>
		<xsl:variable name="varProviderNameOfRefFragmentExpanded" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.expand($varRelPathsToRefFragments,$varProviderNameOfRefFragment)"/>
		<xsl:variable name="varListOfExportedImports" select="$varReferencedFragmentXML//requires/import[@export='true']"/>
		<xsl:for-each select="$varListOfFragmentRelativeLibraryPaths">
			<xsl:element name="dependency">
				<xsl:element name="dc-ref">
					<name>
						<xsl:value-of select="$varRefDCName"/>
					</name>
					<vendor>sap.com</vendor>
				</xsl:element>
				<xsl:element name="pp-ref">
					<xsl:value-of select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.extractJarName(.)"/>
				</xsl:element>
				<at-build-time/>
				<at-runtime/>
			</xsl:element>
		</xsl:for-each>
		<!-- recurse -->
		<xsl:apply-templates select="$varListOfExportedImports"/>
	</xsl:template>
	<!-- Again SWT special case -->
	<xsl:template match="runtime">
		<xsl:if test="not(library) and boolean(ancestor::node()//fragment)">
			<!-- Yes there are no library entries in the fragment.xml but despide that we have libaries !-->
			<xsl:variable name="varMovedLibs" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.copyLibraries($parDCDir, $parPlugInDir)"/>
			<!-- TODO: recures incase we actully get more than one lib-->
			<xsl:if test="string-length($varMovedLibs)>0">
				<redirect:write select="concat($parDCDir,'def/',$varMovedLibs,'.pp')">
					<xsl:element name="public-part" xmlns:IDX="urn:sap.com:PublicPart:1.0" xmlns="http://xml.sap.com/2002/11/PublicPart">
						<xsl:attribute name="version">1.0</xsl:attribute>
						<xsl:element name="name">
							<xsl:value-of select="$varMovedLibs"/>
						</xsl:element>
						<xsl:element name="purpose">compilation</xsl:element>
						<xsl:element name="caption">
							<xsl:value-of select="concat($varMovedLibs,' Jar')"/>
						</xsl:element>
						<xsl:element name="description">Automatically generated public part.</xsl:element>
					</xsl:element>
				</redirect:write>
			</xsl:if>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- source of the public parts -->
	<xsl:template match="runtime/library">
		<xsl:variable name="varLibraryName" select="string(@name)"/>
		<xsl:variable name="varMovedLib" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.copyLibrary($parDCDir, $parPlugInDir, $varLibraryName)"/>
		<xsl:variable name="varJarName" select="java:com.sap.bi.ext.eclipse.ExtensionFunctions.getJarNameFromRelativePath($varLibraryName)"/>
		<redirect:write select="concat($parDCDir,'def/',$varJarName,'.pp')">
			<xsl:element name="public-part" xmlns:IDX="urn:sap.com:PublicPart:1.0" xmlns="http://xml.sap.com/2002/11/PublicPart">
				<xsl:attribute name="version">1.0</xsl:attribute>
				<xsl:element name="name">
					<xsl:value-of select="$varJarName"/>
				</xsl:element>
				<xsl:element name="purpose">compilation</xsl:element>
				<xsl:element name="caption">
					<xsl:value-of select="concat($varJarName,' Jar')"/>
				</xsl:element>
				<xsl:element name="description">Automatically generated public part.</xsl:element>
			</xsl:element>
		</redirect:write>
		<redirect:write select="concat($parDCDir,'def/',$varJarName,'Impl.pp')">
			<xsl:element name="public-part" xmlns:IDX="urn:sap.com:PublicPart:1.0" xmlns="http://xml.sap.com/2002/11/PublicPart">
				<xsl:attribute name="version">1.0</xsl:attribute>
				<xsl:element name="name">
					<xsl:value-of select="concat($varJarName,'Impl')"/>
				</xsl:element>
				<xsl:element name="purpose">assembly</xsl:element>
				<xsl:element name="caption">
					<xsl:value-of select="concat($varJarName,' Assembly Jar')"/>
				</xsl:element>
				<xsl:element name="description">Automatically generated public part.</xsl:element>
			</xsl:element>
		</redirect:write>		
	</xsl:template>
	<xsl:template match="extension">
	<!-- do not care-->
	</xsl:template>
	<xsl:template match="extension-point">
	<!-- do not care-->
	</xsl:template>
</xsl:stylesheet>
