package temp.persistence.gettingstarted.web;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import temp.persistence.gettingstarted.jdo.BusinessLogic;
import temp.persistence.gettingstarted.jdo.Employee;

public class ProcessInput extends HttpServlet {
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		PrintWriter out = response.getWriter();
		try {
			// the plain Java class BusinessLogic.java
			// encapsulates the business logic:
			BusinessLogic businessLogic = new BusinessLogic();
			out.println("<html><body>");
			out.println("<h4>Using Java Data Objects (JDO)</h4>");
			// read the user input
			// invoke the appropriate business logic functionality
			// generate the response (html) page              
			String action = request.getParameter("ACTION");
			if (action.equals("NEW_DEP")) {
				int depId = Integer.parseInt(request.getParameter("DEPID"));
				String depName = request.getParameter("NAME");
				businessLogic.createDepartment(depId, depName);
				out.println("Department \"" + depName + "\" created.");
			} else if (action.equals("NEW_EMP")) {
				int depId = Integer.parseInt(request.getParameter("DEPID"));
				int empId = Integer.parseInt(request.getParameter("EMPID"));
				String firstName = request.getParameter("FIRST_NAME");
				String lastName = request.getParameter("LAST_NAME");
				BigDecimal salary = new BigDecimal(request.getParameter("SALARY"));
				businessLogic.createEmployee(
					empId,
					firstName,
					lastName,
					salary,
					depId);
				out.println("Employee \"" + firstName + " " + lastName + "\" created.");
			} else if (action.equals("LIST")) {
				int depId = Integer.parseInt(request.getParameter("DEPID"));
				Employee[] emps = businessLogic.getEmployeesFromDepartment(depId);
				if (emps.length == 0) {
					out.println("<br>no data");
				} else {
					out.println("<table><tr>");
					out.println("<td>Employee ID</td>");
					out.println("<td>First Name</td>");
					out.println("<td>Last Name</td>");
					out.println("<td>Salary</td>");
					out.println("<td>Department ID</td></tr>");
					for (int i = 0; i < emps.length; i++) {
						out.println("<tr>");
						out.println("<td>" + emps[i].getEmpId() + "</td>");
						out.println("<td>" + emps[i].getFirstName() + "</td>");
						out.println("<td>" + emps[i].getLastName() + "</td>");
						out.println("<td>" + emps[i].getSalary() + "</td>");
						out.println("<td>" + depId + "</td>");
						out.println("</tr>");
					}
					out.println("</table>");
				}
			} else {
				out.println("Illegal action: " + action);
			}
		} catch (Throwable ex) { // catches any exception thrown 
			out.println("Exception caught");
			out.println("<code>");
			ex.printStackTrace(out);
			out.println("</code>");
		} finally {
			out.println("<p><a href=index.html>Home</a><p>");
			out.println("</body></html>");
		}
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}
}