package temp.persistence.gettingstarted.jdo;

import java.math.BigDecimal;
import com.sap.jdo.SAPJDOHelper;

public class Employee {

	// Class attributes: the persistent fields of an employee.
	// Also defined inside the file Employee.jdo
	private int empId;
	private String firstName;
	private String lastName;
	private BigDecimal salary;
	private Department department;

	// Required: a no-args constructor
	public Employee() {
		this.empId = -1;
		this.firstName = "INITIAL";
		this.lastName = "INITIAL";
		salary = new BigDecimal(0.0);
		department = null;
	}

	// Constructor where the ID is set
	public Employee(int empId) {
		this.empId = empId;
		this.firstName = "INITIAL";
		this.lastName = "INITIAL";
		salary = new BigDecimal(0.0);
		department = null;
	}

	// Implement the getter methods of the class
	public Department getDepartment() {
		return department;
	}

	public int getEmpId() {
		return empId;
	}

	public String getFirstName() {
		return firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public BigDecimal getSalary() {
		return salary;
	}

	// Implement the setter methods of the class
	public void setDepartment(Department dept) {
		this.department = dept;
	}

	public void setFirstName(String fname) {
		firstName = fname;
	}

	public void setLastName(String lname) {
		lastName = lname;
	}

	public void setSalary(BigDecimal sal) {
		salary = sal;
	}
	
	static public class Id {

		//	   public field corresponding to the primary key of the PC class
		public int empId;

		static { // establish the relation: Employee$Id class
			// is the identity class for the PC class Employee.
			SAPJDOHelper.registerPCClass(Employee.class);
		}

		public Id() { // required: a no-args constructor
		}

		public Id(int empId) {
			this.empId = empId;
		}

		public Id(String string) { // required: a string constructor
			// defined as the counterpart of toString()
			empId = Integer.parseInt(string);
		}

		public int hashCode() { // required: implement hashCode() 
			return empId;
		}

		public String toString() { // required: toString() defined
			// as the counterpart of the string constructor 
			return Integer.toString(empId);
		}

		public boolean equals(Object that) { // required: define equals()
			if (that == null || !(that instanceof Id)) return false;
			else return empId == ((Id) that).empId;
		}
	}
}