package temp.persistence.gettingstarted.jdo;

import java.util.*;
import com.sap.jdo.SAPJDOHelper;

public class Department {

	// Class attributes: the persistent fields of a department.
	// Also defined inside the file Department.jdo
	private int depId;
	private String name;
	private Set employees;

	// Required: a no-args constructor
	public Department() {
		this.depId = -1;
		name = "INITIAL";
		employees = new HashSet();
	}

	// Constructor where the ID is set
	public Department(int depId) {
		this.depId = depId;
		name = "INITIAL";
		employees = new HashSet();
	}

	// Implement the getter methods
	public int getDepId() {
		return depId;
	}

	public Collection getEmployees() {
		return employees;
	}

	public String getName() {
		return name;
	}

	// Implement the setter methods
	public void setName(String newName) {
		name = newName;
	}

	public void setEmployees(Set empSet) {
		this.employees = empSet;
	}

	// Assign employees to the department
	public void addEmployee(Employee emp) {
		if (employees == null)
			employees = new HashSet();
		employees.add(emp);
	}

	// Remove employees from the department
	public void removeEmployee(Employee emp) {
		if (employees != null)
			employees.remove(emp);
	}

	static public class Id {
	
		//	   public field corresponding to the primary key of the PC class
	
		public int depId;
	
		static { // establish the relation: Department$Id class
			// is the identity class for the PC class Department. 
			SAPJDOHelper.registerPCClass(Department.class);
		}

		public Id() { // required: a no-args constructor 
		}

		public Id(String string) { // required: a string constructor 
			// defined as the counterpart of toString() 
			depId = Integer.parseInt(string);
		}

		public Id(int depId) {
			this.depId = depId;
		}

		public int hashCode() { // required: implement hashCode()  
			return depId;
		}

		public String toString() { // required: toString() defined
			// as the counterpart of the string constructor 
			return Integer.toString(depId);
		}

		public boolean equals(Object that) { // required: define equals()
			if (that == null || !(that instanceof Id)) return false;
			else return depId == ((Id) that).depId;
		}
	}
}