package temp.persistence.gettingstarted.jdo;

import java.math.BigDecimal;
import java.util.Collection;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BusinessLogic {

	private PersistenceManagerFactory pmf;
	// Persistence Manager Factory (PMF)

	public BusinessLogic() throws NamingException {
		// Get the Persistence Manager Factory via JNDI using a reference.
		// (You have to declare this reference within the deployment descriptor.)      
		Context ctx = new InitialContext();
		pmf = (PersistenceManagerFactory) ctx.lookup("java:comp/env/jdo/defaultPMF");
	}

	public void createDepartment(int depId, String name) throws JDOException {
		PersistenceManager pm = null;
		try {
			Department dep = new Department(depId);
			dep.setName(name);
			// Get the Persistence Manager (PM)
			// PM manages transactions, the life cycle of objects, etc.
			pm = pmf.getPersistenceManager();
			// Start a local transaction.
			Transaction tx = pm.currentTransaction();
			tx.begin();
			// Create a new persistent department object
			pm.makePersistent(dep);
			// Insert the new department to the database
			tx.commit();
		} finally {
			// Close the Persistence Manager
			if (pm != null && !pm.isClosed()) {
				if (pm.currentTransaction().isActive()) pm.currentTransaction().rollback();
				pm.close();
			}
		}
	}

	public void createEmployee(int empId, String fName, String lName, BigDecimal salary, int depId) throws JDOException {
		PersistenceManager pm = null;
		try {
			Employee emp = new Employee(empId);
			emp.setFirstName(fName);
			emp.setLastName(lName);
			emp.setSalary(salary);
			//	  Obtain the related department object. We assume the department exists.
			pm = pmf.getPersistenceManager();
			Department department = (Department) pm.getObjectById(new Department.Id(depId), false);
			// Start a local transaction
			Transaction tx = pm.currentTransaction();
			tx.begin();
			// Establish a relationship between the employee and the department
			emp.setDepartment(department);
			department.addEmployee(emp);
			// Create a new persistent employee object
			pm.makePersistent(emp);
			// Write the new employee to the database. Update the department object.
			tx.commit();
		} finally {
			// Close the Persistence Manager
			if (pm != null && !pm.isClosed()) {
				if (pm.currentTransaction().isActive()) pm.currentTransaction().rollback();
				pm.close();
			}
		}
	}

	public Employee[] getEmployeesFromDepartment(int departmentId) throws JDOException {
		PersistenceManager pm = null;
		Employee[] result = new Employee[] {
		};
		try {
			// Prepare the query.
			pm = pmf.getPersistenceManager();
			Query query = pm.newQuery(Employee.class, "department.depId == id");
			query.declareParameters("int id");
			// Cast the return value of query.execute() to java.util.Collection
			Collection col = (Collection) query.execute(new Integer(departmentId));
			// convert the collection to an array. Return the array.
			// The method returns Employee PC objects for simplicity
			// It is recommended to create additional plain Java
			// objects (Data Transfer Objects DTO) as the return 
			//objects 
			pm.retrieveAll(col);
			pm.makeTransientAll(col);
			result = (Employee[]) col.toArray(new Employee[] {
			});
			//free the resources
			query.close(col);
		} finally {
			// Close the Persistence Manager
			if (pm != null && !pm.isClosed()) pm.close();
		}
		return (result);
	}
}