/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.urlgenerator;
import com.sapportals.portal.security.usermanagement.IGroup;

import com.sapportals.portal.security.usermanagement.IUser;
import com.sapportals.wcm.IWcmConst;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.ICollection;
import com.sapportals.wcm.util.uri.URI;

import java.util.Collection;
import java.util.Properties;

/**
 * ServletCallParameters <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author andreas.heix@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/urlgenerator/ServletCallParameters.java#4
 *      $
 * @deprecated As of EP 5.0 SP4, this interface is no longer in use
 */
public class ServletCallParameters {

  private String xmlFile = IWcmConst.SERVICE_SERVLET_VALUE_XML_FILE;
  private String startPage = IWcmConst.SERVICE_SERVLET_VALUE_STARTPAGE;
  private URI resourceURL;
  private String serviceType;
  private String serviceAction;
  private String serviceID;
  private String stringOne;
  private String stringTwo;

  public void setXmlFile(String value) {
    this.xmlFile = value;
  }

  public void setStartPage(String value) {
    this.startPage = value;
  }

  public void setResourceURL(URI value) {
    this.resourceURL = value;
  }

  public void setServiceType(String value) {
    this.serviceType = value;
  }

  public void setServiceAction(String value) {
    this.serviceAction = value;
  }

  public void setServiceID(String value) {
    this.serviceID = value;
  }

  public void setStringOne(String value) {
    this.stringOne = value;
  }

  public void setStringTwo(String value) {
    this.stringTwo = value;
  }

  public String getXmlFile() {
    return this.xmlFile;
  }

  public String getStartPage() {
    return this.startPage;
  }

  public URI getResourceURL() {
    return this.resourceURL;
  }

  public String getServiceType() {
    return this.serviceType;
  }

  public String getServiceAction() {
    return this.serviceAction;
  }

  public String getServiceID() {
    return this.serviceID;
  }

  public String getStringOne() {
    return this.stringOne;
  }

  public String getStringTwo() {
    return this.stringTwo;
  }

  public Properties getProperties() {
    Properties properties = new Properties();
    properties.setProperty(IWcmConst.SERVICE_SERVLET_PARAMETER_XML_FILE, this.getXmlFile());
    properties.setProperty(IWcmConst.SERVICE_SERVLET_PARAMETER_STARTPAGE, this.getStartPage());
    if (this.getResourceURL() != null) {
      properties.setProperty(IWcmConst.SERVICE_SERVLET_PARAMETER_RESOURCE, this.getResourceURL().toString());
    }

    this.safeSetProperty(properties, IWcmConst.SERVICE_SERVLET_PARAMETER_ACTION, this.getServiceAction());
    this.safeSetProperty(properties, IWcmConst.SERVICE_SERVLET_PARAMETER_SERVICE_ID, this.getServiceID());
    this.safeSetProperty(properties, IWcmConst.SERVICE_SERVLET_PARAMETER_SERVICE_TYPE, this.getServiceType());
    this.safeSetProperty(properties, IWcmConst.SERVICE_SERVLET_PARAMETER_STRING_ONE, this.getStringOne());
    this.safeSetProperty(properties, IWcmConst.SERVICE_SERVLET_PARAMETER_STRING_TWO, this.getStringTwo());

    return properties;
  }

  private void safeSetProperty(Properties properties, String key, String value) {
    if (value != null) {
      properties.setProperty(key, value);
    }
  }

}
// EOF
