/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.urlgenerator;

/**
 * An enumeration of all possible keys which can be used to query the
 * corresponding path from <code>IUrlGeneratorService</code> . <p>
 *
 * Copyright (c) SAP-AG 2002
 *
 * @author ralf.hammer@sap.com
 * @version $Id:$
 */
public final class PathKey {
  //----------------------------------------------------------------------------
  // Constants
  //----------------------------------------------------------------------------

  /** */
  public final static PathKey CONTENT_ACCESS_PATH = new PathKey("contentaccesspath");

  /** */
  public final static PathKey IMAGE_PATH = new PathKey("imagepath");

  /** */
  public final static PathKey IVIEW_IMAGE_PATH = new PathKey("iviewimagepath");

  /** */
  public final static PathKey VIEWER_PATH = new PathKey("viewer");

  /** denotes the path, where to find the CSS files used by XML Forms */
  public final static PathKey XML_FORMS_PATH = new PathKey("XMLFormscssurl");

  /** */
  public final static PathKey APPLOG_DOWNLOAD_PAGE = new PathKey("applogdownloadservlet");

  /** */
  public final static PathKey APPLOG_PAGE = new PathKey("applogpath");

  /** a special dialog showing properties and offering services available for a resource */
  public final static PathKey DETAILS_PAGE = new PathKey("detailspage");

  /** a special dialog showing properties and offering services available for a resource */
  public final static PathKey RESOURCE_PROPERTIES_PAGE = new PathKey("resourceproppage");

  /** a special dialog showing child resources, navigation information etc. */
  public final static PathKey EXPLORER_PAGE = new PathKey("explorerservlet");

  /** a special dialog showing child resources, navigation information etc. */
  public final static PathKey NAVIGATION_PAGE = new PathKey("navigationservlet");

  /** */
  public final static PathKey FAVORITES_PAGE = new PathKey("favoritesservlet");

  /** denotes the path to the ICE server */
  public final static PathKey ICE_SERVER = new PathKey("icepath");

  /** */
  public final static PathKey LINKLIST_PAGE = new PathKey("linklistservlet");

  /** */
  public final static PathKey SERVICE_PAGE = new PathKey("serviceservlet");

  /** */
  public final static PathKey SUBSCRIPTION_ADMIN_PAGE = new PathKey("subscriptionadmin");
  
  /** */
  public final static PathKey SUBSCRIPTION_PAGE = new PathKey("subscription");

  /** */
  public final static PathKey BASIC_SEARCH_PAGE = new PathKey("basicsearch");

  /** */
  public final static PathKey COLLABORATION_PAGE = new PathKey("collaboration");

  /** */
  public final static PathKey ACTIONINBOX_PAGE = new PathKey("actioninbox");

  /** */
  public final static PathKey INDEX_LOG_PAGE = new PathKey("indexlog");

  /** */
  public final static PathKey METADATA_DOWNLOAD_PAGE = new PathKey("metadatadownload");
  
  /** */
  public final static PathKey TREX_ADMIN_PAGE = new PathKey("trexadmin");
  
  /** */
  public final static PathKey UIDISCUSSION_PAGE = new PathKey("uidiscussion");

  /** */
  public final static PathKey XCRAWLER_MONITOR_PAGE = new PathKey("xcrawlermonitor");
  
  /** */
  public final static PathKey INDEXING_MONITOR_PAGE = new PathKey("indexingmonitor");
  
  /** */
  public final static PathKey INDEXING_MONITOR_DETAILS_PAGE = new PathKey("indexingmonitordetails");

  /** */
  public final static PathKey XCRAWLER_MONITOR_DETAILS_PAGE = new PathKey("xcrawlermonitordetails");

  /** */
  public final static PathKey XMLFORMS_BROWSER_PAGE = new PathKey("xmlformsbrowser");
  /** */
  
  public final static PathKey RESOURCE_SELECTOR_PAGE = new PathKey("resourceselector");
  
  public final static PathKey CLIENT_SIDE_EDIT_PAGE = new PathKey("clientsideedit");

  /** */
  public final static PathKey XML_FORMS_LIST_PAGE = new PathKey("listservlet");

  /** */
  public final static PathKey XML_FORMS_EDIT_PAGE = new PathKey("editservlet");

  /** */
  public final static PathKey XML_FORMS_PREVIEW_PAGE = new PathKey("previewservlet");

  /** */
  public final static PathKey XML_FORMS_XFBUILDER_PAGE = new PathKey("xfbuilderservlet");
  
  /** */
  public final static PathKey USERMAPPING_PAGE = new PathKey("usermappingservlet");
  
  /** */
  public final static PathKey SEND_MAIL_PAGE = new PathKey("sendmail");
  
  /** */
  public final static PathKey FEEDBACK_PAGE = new PathKey("feedback");
  
  /** a special dialog showing highlighted content found by search */
  public final static PathKey HIGHLIGHTED_CONTENT_PAGE = new PathKey("highlightedcontent");

  //----------------------------------------------------------------------------
  // Attributes
  //----------------------------------------------------------------------------

  /**
   * the key of the path
   */
  private final String key;


  //----------------------------------------------------------------------------
  // Methods
  //----------------------------------------------------------------------------

  /**
   * Creates a new path key for retrieving the URI of the associated path from
   * <code>IURLGeneratorService</code> . <p>
   *
   * This constructor is private, use the predefined values instead.
   *
   * @param key the key of a path
   */
  private PathKey(String key) {
    this.key = key;
  }

  /**
   * Gets the key of the path. <p>
   *
   * This method is package local; it's used only by the class <code>
   * URLGenerator</code> residing in the same package.
   *
   * @return the key of the path
   */
  public String getKey() {
    return this.key;
  }

}// class PathKey
