/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.urlgenerator;

import com.sapportals.wcm.repository.ResourceException;

import com.sapportals.wcm.util.uri.*;

/**
 * Generic interface for the generation of user management specific RIDs. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IUserManagementRidGenerator.java,v 1.1 2002/08/22 17:53:41 jre
 *      Exp $
 */
public interface IUserManagementRidGenerator {

  public final static String MT_PHOTO = "image/*";
  public final static String MT_RDF = "text/rdf";
  public final static String MT_VCARD = "text/x-vcard";

  /**
   * Returns the RID of the specified principal. This method is only useful when
   * using the new usermanagement. The old usermanagement should always return
   * <code>null</code> .
   *
   * @param principalId id of the principal
   * @return RID for resource representing the principal
   */
  public RID getPrincipalResourceRid(String principalId);

  /**
   * @param groupId id of the group
   * @return RID for resource representing the group
   */
  public RID getGroupResourceRid(String groupId);

  /**
   * @return set of all collections representing principals (users, groups and
   *      roles)
   */
  public IRidSet getPrincipalCollectionRidSet();

  /**
   * @param roleId id of the role
   * @return RID for resource representing the role
   */
  public RID getRoleResourceRid(String roleId);

  /**
   * @param userId id of the user
   * @return RID for resource representing the user
   */
  public RID getUserResourceRid(String userId);

  /**
   * @param userId id of the user
   * @param mimetype MIME type of requested user data
   * @return RID for resource representing the user in the given mime type
   * @throws ResourceException when mime type not available
   */
  public RID getUserResourceRid(String userId, String mimetype)
    throws ResourceException;
}

