/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.urlgenerator;

import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.ResourceException;

/**
 * Used by the URL Generator Service to resolve placeholders within URIs. <p>
 *
 * Copyright (c) SAP AG
 *
 * @author ralf.hammer@sap.com
 * @version $Id:$
 */
public interface IPlaceholderResolver {

  /**
   * Returns the placeholder this instance of <code>IPlaceholderResolver</code>
   * can handle.
   *
   * @return the placeholder which can be resolved by this instance
   */
  public String getPlaceholder();

  /**
   * Replaces all occurrences of placeholder in <code>str</code> by the
   * corresponding value.
   *
   * @param str the <code>String</code> to resolve its contained placeholders
   * @param context the <code>IResourceContext</code>
   * @return a <code>String</code> containing the resolved version of the
   *      original string
   * @throws ResourceException on error
   */
  public String resolvePlaceholder(String str, IResourceContext context)
    throws ResourceException;

}// INTERFACE IPlaceholderResolver
