
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDTray.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro Tray API.
 *
 * Tray is used to group a number of UI elements under a common header.
 * A Tray may be collapsed by setting expanded to <code>false</code>.
 * A collapsed tray displays only its header.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDTray extends IWDScrollContainer
{

  // Event "onToggle"
  
  /**
   * Returns the action to which the event <code>onToggle</code> is mapped.
   *
   * The action performed when the tray is toggled (collapsed resp. expanded).
   * Event parameter is the new expansion state.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnToggle()
   */
  public IWDAction getOnToggle();

  /**
   * Maps the event <code>onToggle</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnToggle()
   */
  public void setOnToggle(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onToggle</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>boolean expanded - The new expansion state.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnToggle()
   */  
  public IWDParameterMapping mappingOfOnToggle();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>design</code>.
   */
  public static final WDTrayDesign DEFAULT_DESIGN = WDTrayDesign.TRANSPARENT;
  
  /**
   * Default value of property <code>expanded</code>.
   */
  public static final boolean DEFAULT_EXPANDED = true;
  
  /**
   * Default value of property <code>hasContentPadding</code>.
   */
  public static final boolean DEFAULT_HAS_CONTENT_PADDING = true;

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the Tray (It's like a title) in the accessibility mode.  Should be used if no title is available. It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: design, Visibility: public, Type: TrayDesign, Initial value: transparent
     convertible: false
  */

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the design
   *                property is bound
   */
  public void bindDesign(String path);

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       design property is bound
   */
  public void bindDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>design</code>.
   *
   * @return        the path of the context attribute to which the design
   *                is currently bound
   */
  public String bindingOfDesign();

  /**
   * Returns the value of the <code>design</code> property.
   * The initial value is <code>WDTrayDesign.TRANSPARENT</code>.
   *
   * Determines the design of this tray.
   *
   * @return      the current value of the design property
   * @see #setDesign(WDTrayDesign)
   */
  public WDTrayDesign getDesign();

  /**
   * Sets property <code>design</code> to the new value.
   *
   * @param value     the new value of the design property
   * @see #getDesign()
   */
  public void setDesign(WDTrayDesign value);

  /* Bound Property
     Name: expanded, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>expanded</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the expanded
   *                property is bound
   */
  public void bindExpanded(String path);

  /**
   * Binds property <code>expanded</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       expanded property is bound
   */
  public void bindExpanded(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>expanded</code>.
   *
   * @return        the path of the context attribute to which the expanded
   *                is currently bound
   */
  public String bindingOfExpanded();

  /**
   * Returns the value of the <code>expanded</code> property.
   * The initial value is <code>true</code>.
   *
   * Determines if this tray is expanded.
   *
   * @return      the current value of the expanded property
   * @see #setExpanded(boolean)
   */
  public boolean getExpanded();

  /**
   * Sets property <code>expanded</code> to the new value.
   *
   * @param value     the new value of the expanded property
   * @see #getExpanded()
   */
  public void setExpanded(boolean value);

  /* Bound Property
     Name: hasContentPadding, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the hasContentPadding
   *                property is bound
   */
  public void bindHasContentPadding(String path);

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       hasContentPadding property is bound
   */
  public void bindHasContentPadding(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>hasContentPadding</code>.
   *
   * @return        the path of the context attribute to which the hasContentPadding
   *                is currently bound
   */
  public String bindingOfHasContentPadding();

  /**
   * Returns the value of the <code>hasContentPadding</code> property.
   * The initial value is <code>true</code>.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current value of the hasContentPadding property
   * @see #setHasContentPadding(boolean)
   */
  public boolean getHasContentPadding();

  /**
   * Sets property <code>hasContentPadding</code> to the new value.
   *
   * @param value     the new value of the hasContentPadding property
   * @see #getHasContentPadding()
   */
  public void setHasContentPadding(boolean value);

  /* outgoing aggregation:
     Name=Tray.Header, isAbstract=false
Role A: Name=Header, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tray, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Header instance.
   *
   * The header of a tray contains a caption.
   *
   * @return      the current Header
   * @see #setHeader(IWDCaption)
   */
  public IWDCaption getHeader();

  /**
   * Sets the Header instance.
   *
   * @param header    the new header
   * @see #getHeader()
   */
  public void setHeader(IWDCaption header);

  /**
   * Destroys the Header instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyHeader();

  /* outgoing aggregation:
     Name=Tray.PopupMenu, isAbstract=false
Role A: Name=PopupMenu, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tray, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the PopupMenu instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current PopupMenu
   * @see #setPopupMenu(IWDMenu)
   */
  public IWDMenu getPopupMenu();

  /**
   * Sets the PopupMenu instance.
   *
   * @param popupMenu    the new popupMenu
   * @see #getPopupMenu()
   */
  public void setPopupMenu(IWDMenu popupMenu);

  /**
   * Destroys the PopupMenu instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyPopupMenu();

  /* outgoing aggregation:
     Name=Tray.ToolBar, isAbstract=false
Role A: Name=ToolBar, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Tray, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the ToolBar instance.
   *
   * A tray may contain a toolbar.
   *
   * @return      the current ToolBar
   * @see #setToolBar(IWDToolBar)
   */
  public IWDToolBar getToolBar();

  /**
   * Sets the ToolBar instance.
   *
   * @param toolBar    the new toolBar
   * @see #getToolBar()
   */
  public void setToolBar(IWDToolBar toolBar);

  /**
   * Destroys the ToolBar instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyToolBar();

//@@begin extensions
//@@end

}
