
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDToolBar.java#4 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro ToolBar API.
 *
 * The ToolBar UI element represents a collection of "tools" that belong to or may be applied to the containing UI element.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDToolBar extends IWDViewElement
{
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>design</code>.
   */
  public static final WDToolBarDesign DEFAULT_DESIGN = WDToolBarDesign.STANDARD;
  
  /**
   * Default value of property <code>enabled</code>.
   */
  public static final boolean DEFAULT_ENABLED = true;
  
  /**
   * Default value of property <code>visible</code>.
   */
  public static final WDVisibility DEFAULT_VISIBLE = WDVisibility.VISIBLE;
  
  /**
   * Default value of property <code>wrapping</code>.
   */
  public static final boolean DEFAULT_WRAPPING = true;

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the Toolbar (it's like a title) in the accessibility mode. It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: design, Visibility: public, Type: ToolBarDesign, Initial value: standard
     convertible: false
  */

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the design
   *                property is bound
   */
  public void bindDesign(String path);

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       design property is bound
   */
  public void bindDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>design</code>.
   *
   * @return        the path of the context attribute to which the design
   *                is currently bound
   */
  public String bindingOfDesign();

  /**
   * Returns the value of the <code>design</code> property.
   * The initial value is <code>WDToolBarDesign.STANDARD</code>.
   *
   * The design of the toolbar.
   *
   * @return      the current value of the design property
   * @see #setDesign(WDToolBarDesign)
   */
  public WDToolBarDesign getDesign();

  /**
   * Sets property <code>design</code> to the new value.
   *
   * @param value     the new value of the design property
   * @see #getDesign()
   */
  public void setDesign(WDToolBarDesign value);

  /* Bound Property
     Name: enabled, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the enabled
   *                property is bound
   */
  public void bindEnabled(String path);

  /**
   * Binds property <code>enabled</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       enabled property is bound
   */
  public void bindEnabled(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>enabled</code>.
   *
   * @return        the path of the context attribute to which the enabled
   *                is currently bound
   */
  public String bindingOfEnabled();

  /**
   * Returns the value of the <code>enabled</code> property.
   * The initial value is <code>true</code>.
   *
   * Determines if the toolbar is enabled.
   *
   * @return      the current value of the enabled property
   * @see #setEnabled(boolean)
   */
  public boolean getEnabled();

  /**
   * Sets property <code>enabled</code> to the new value.
   *
   * @param value     the new value of the enabled property
   * @see #getEnabled()
   */
  public void setEnabled(boolean value);

  /* Bound Property
     Name: visible, Visibility: public, Type: Visibility, Initial value: visible
     convertible: false
  */

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the visible
   *                property is bound
   */
  public void bindVisible(String path);

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       visible property is bound
   */
  public void bindVisible(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>visible</code>.
   *
   * @return        the path of the context attribute to which the visible
   *                is currently bound
   */
  public String bindingOfVisible();

  /**
   * Returns the value of the <code>visible</code> property.
   * The initial value is <code>WDVisibility.VISIBLE</code>.
   *
   * Determines if the toolbar is visible.
   *
   * @return      the current value of the visible property
   * @see #setVisible(WDVisibility)
   */
  public WDVisibility getVisible();

  /**
   * Sets property <code>visible</code> to the new value.
   *
   * @param value     the new value of the visible property
   * @see #getVisible()
   */
  public void setVisible(WDVisibility value);

  /* Bound Property
     Name: wrapping, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>wrapping</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the wrapping
   *                property is bound
   */
  public void bindWrapping(String path);

  /**
   * Binds property <code>wrapping</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       wrapping property is bound
   */
  public void bindWrapping(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>wrapping</code>.
   *
   * @return        the path of the context attribute to which the wrapping
   *                is currently bound
   */
  public String bindingOfWrapping();

  /**
   * Returns the value of the <code>wrapping</code> property.
   * The initial value is <code>true</code>.
   *
   * Determines if the toolBar is wrapped.
   *
   * @return      the current value of the wrapping property
   * @see #setWrapping(boolean)
   */
  public boolean getWrapping();

  /**
   * Sets property <code>wrapping</code> to the new value.
   *
   * @param value     the new value of the wrapping property
   * @see #getWrapping()
   */
  public void setWrapping(boolean value);

  /* outgoing aggregation:
     Name=ToolBar.ToolBarItems, isAbstract=false
Role A: Name=ToolBarItems, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=ToolBar, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given ToolBarItem at the end of the list of ToolBarItems.
   *
   * @param aToolBarItem     the ToolBarItem to be added into the list
   * @see #getToolBarItems()
   */
  public void addToolBarItem(IWDToolBarItem aToolBarItem);

  /**
   * Adds the given ToolBarItem at the specified index in the list of ToolBarItems.
   *
   * @param aToolBarItem     the ToolBarItem to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getToolBarItems()
   */
  public void addToolBarItem(IWDToolBarItem aToolBarItem, int index);

  /**
   * Swaps the ToolBarItems at the given indices.
   * 
   * @param i index of the first ToolBarItem to swap
   * @param j index of the second ToolBarItem to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapToolBarItems(int i, int j); 
   
  /**
   * Returns the list of ToolBarItems.
   *
   * A toolbar contains a number of toolbar items like buttons, drop-down lists or separators.
   *
   * @return      an array containing references to the current ToolBarItems
   */
  public IWDToolBarItem[] getToolBarItems();

  /**
   * Returns the ToolBarItem at the given index.
   *
   * @return ToolBarItem at the given index
   */
  public IWDToolBarItem getToolBarItem(int index);

  /**
   * Returns the index of the given element in the list of ToolBarItems
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfToolBarItem(IWDToolBarItem aToolBarItem);
       
  /**
   * Returns the number of ToolBarItems.
   * 
   * @return the current number of ToolBarItems.
   * @see #getToolBarItems()
   */
  public int numberOfToolBarItems();
  
  /**
   * Checks if there exist ToolBarItems.
   *
   * @return      <code>true</code> if there are ToolBarItems;
   *              <code>false</code> otherwise.
   * @see #getToolBarItems()
   */
  public boolean hasToolBarItems();

  /**
   * Returns an iterator over the list of ToolBarItems.
   *
   * @return      an iterator over the current ToolBarItems
   * @see #getToolBarItems()
   */
  public Iterator iterateToolBarItems();

  /**
   * Removes the entry at the given index from the list of ToolBarItems.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addToolBarItem(IWDToolBarItem)
   * @see #getToolBarItems()
   */
  public IWDToolBarItem removeToolBarItem(int index);

  /**
   * Removes the entry with the given ID from the list of ToolBarItems.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addToolBarItem(IWDToolBarItem)
   * @see #getToolBarItems()
   */
  public IWDToolBarItem removeToolBarItem(String id);

  /**
   * Removes all entries from the list of ToolBarItems.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addToolBarItem(IWDToolBarItem)
   * @see #getToolBarItems()
   */
  public void removeAllToolBarItems(); 

  /**
   * Destroys all entries in the list of ToolBarItems.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllToolBarItems();

  /* outgoing aggregation:
     Name=ToolBar.ToolBarRightItems, isAbstract=false
Role A: Name=ToolBarRightItems, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=ToolBar, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given ToolBarRightItem at the end of the list of ToolBarRightItems.
   *
   * @param aToolBarItem     the ToolBarRightItem to be added into the list
   * @see #getToolBarRightItems()
   */
  public void addToolBarRightItem(IWDToolBarItem aToolBarItem);

  /**
   * Adds the given ToolBarRightItem at the specified index in the list of ToolBarRightItems.
   *
   * @param aToolBarItem     the ToolBarRightItem to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getToolBarRightItems()
   */
  public void addToolBarRightItem(IWDToolBarItem aToolBarItem, int index);

  /**
   * Swaps the ToolBarRightItems at the given indices.
   * 
   * @param i index of the first ToolBarRightItem to swap
   * @param j index of the second ToolBarRightItem to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapToolBarRightItems(int i, int j); 
   
  /**
   * Returns the list of ToolBarRightItems.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current ToolBarRightItems
   */
  public IWDToolBarItem[] getToolBarRightItems();

  /**
   * Returns the ToolBarRightItem at the given index.
   *
   * @return ToolBarRightItem at the given index
   */
  public IWDToolBarItem getToolBarRightItem(int index);

  /**
   * Returns the index of the given element in the list of ToolBarRightItems
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfToolBarRightItem(IWDToolBarItem aToolBarItem);
       
  /**
   * Returns the number of ToolBarRightItems.
   * 
   * @return the current number of ToolBarRightItems.
   * @see #getToolBarRightItems()
   */
  public int numberOfToolBarRightItems();
  
  /**
   * Checks if there exist ToolBarRightItems.
   *
   * @return      <code>true</code> if there are ToolBarRightItems;
   *              <code>false</code> otherwise.
   * @see #getToolBarRightItems()
   */
  public boolean hasToolBarRightItems();

  /**
   * Returns an iterator over the list of ToolBarRightItems.
   *
   * @return      an iterator over the current ToolBarRightItems
   * @see #getToolBarRightItems()
   */
  public Iterator iterateToolBarRightItems();

  /**
   * Removes the entry at the given index from the list of ToolBarRightItems.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addToolBarRightItem(IWDToolBarItem)
   * @see #getToolBarRightItems()
   */
  public IWDToolBarItem removeToolBarRightItem(int index);

  /**
   * Removes the entry with the given ID from the list of ToolBarRightItems.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addToolBarRightItem(IWDToolBarItem)
   * @see #getToolBarRightItems()
   */
  public IWDToolBarItem removeToolBarRightItem(String id);

  /**
   * Removes all entries from the list of ToolBarRightItems.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addToolBarRightItem(IWDToolBarItem)
   * @see #getToolBarRightItems()
   */
  public void removeAllToolBarRightItems(); 

  /**
   * Destroys all entries in the list of ToolBarRightItems.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllToolBarRightItems();

//@@begin extensions
//@@end

}
