
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDTimedTrigger.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro TimedTrigger API.
 *
 * UI element that automatically and periodically triggers a UI element event with a defined delay.
 * TimedTrigger is currently invisible like InvisibleElement, thus it ignores both its tooltip and its visibility. Nevertheless it occupies a cell in certain layouts like MatrixLayout.
 * To use a timed trigger you have to bind its "onAction" event to an action and set its "delay" property to the desired delay in seconds.
 * There are several ways to turn off a timed trigger. The most convenient way is to disable the action this trigger is bound to (like you would do with a button). Other possibilities are setting the delay to 0 or disabling the timed trigger like any other UI element.
 * Caution: Triggering the action rudely interrupts user interactions!
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDTimedTrigger extends IWDUIElement
{

  // Event "onAction"
  
  /**
   * Returns the action to which the event <code>onAction</code> is mapped.
   *
   * The action to be triggered when the specified delay has passed.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnAction()
   */
  public IWDAction getOnAction();

  /**
   * Maps the event <code>onAction</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnAction()
   */
  public void setOnAction(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onAction</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>none</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnAction()
   */  
  public IWDParameterMapping mappingOfOnAction();
  
  
  /**
   * Default value of property <code>delay</code>.
   */
  public static final int DEFAULT_DELAY = 0;

  /* Bound Property
     Name: delay, Visibility: public, Type: Integer, Initial value: 0
     convertible: false
  */

  /**
   * Binds property <code>delay</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the delay
   *                property is bound
   */
  public void bindDelay(String path);

  /**
   * Binds property <code>delay</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       delay property is bound
   */
  public void bindDelay(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>delay</code>.
   *
   * @return        the path of the context attribute to which the delay
   *                is currently bound
   */
  public String bindingOfDelay();

  /**
   * Returns the value of the <code>delay</code> property.
   * The initial value is <code>0</code>.
   *
   * The delay in seconds before the specified action is fired; must not be negative. A delay of 0 means that the timer is off and no action is triggered. The delay counts from the moment the response is received by the client. Thus the timer is restarted on every roundtrip to the server, e.g. due to a user interaction.
   * Very short delays (e.g. below 5 seconds) must be handled with extreme care and might be deprecated in the future.
   *
   * @return      the current value of the delay property
   * @see #setDelay(int)
   */
  public int getDelay();

  /**
   * Sets property <code>delay</code> to the new value.
   *
   * @param value     the new value of the delay property
   * @see #getDelay()
   */
  public void setDelay(int value);

//@@begin extensions
//@@end

}
