
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDTable.java#4 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro Table API.
 *
 * Table represents a two-dimensional data set arranged in rows and columns.
 * <p>
 * <strong>Data binding:</strong>
 * <br>
 * The table gets its data from a context node <code>X</code>.
 * <p>
 * The number of table rows is given by the number of elements in <code>X</code>.
 * The selected table rows are given by the selection of <code>X</code>.
 * The editable row is determined by the lead selection of <code>X</code>.
 * <p>
 * Table columns are defined by aggregating TableColumn objects.
 * Each table column has a table cell editor.
 * Every property of the table cell editor may be bound either
 * <ol>
 * <li>to an attribute of the context node <code>X</code>, or
 * <li>to a context root attribute.
 * </ol>
 * In the first case, the property value in row <code>i</code> is determined by the attribute value of the <code>i</code>th node element.
 * Otherwise, the property value is the same for all rows and given by the root attribute's value.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDTable extends IWDUIElement
{

  // Event "onFilter"
  
  /**
   * Returns the action to which the event <code>onFilter</code> is mapped.
   *
   * The event raised when the filter button is pressed.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnFilter()
   */
  public IWDAction getOnFilter();

  /**
   * Maps the event <code>onFilter</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnFilter()
   */
  public void setOnFilter(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onFilter</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>none</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnFilter()
   */  
  public IWDParameterMapping mappingOfOnFilter();
  

  // Event "onLeadSelect"
  
  /**
   * Returns the action to which the event <code>onLeadSelect</code> is mapped.
   *
   * The action performed when the lead selection of the table was changed.
   * Event parameters are the ID of the column and the zero based index of the row
   * where the selection occured.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnLeadSelect()
   */
  public IWDAction getOnLeadSelect();

  /**
   * Maps the event <code>onLeadSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnLeadSelect()
   */
  public void setOnLeadSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onLeadSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String col - The ID of the selected column.</li>
   * <li>int row - The zero based index of the selected row.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnLeadSelect()
   */  
  public IWDParameterMapping mappingOfOnLeadSelect();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>design</code>.
   */
  public static final WDTableDesign DEFAULT_DESIGN = WDTableDesign.STANDARD;
  
  /**
   * Default value of property <code>firstVisibleRow</code>.
   */
  public static final int DEFAULT_FIRST_VISIBLE_ROW = 0;
  
  /**
   * Default value of property <code>footerVisible</code>.
   */
  public static final boolean DEFAULT_FOOTER_VISIBLE = true;
  
  /**
   * Default value of property <code>readOnly</code>.
   */
  public static final boolean DEFAULT_READ_ONLY = false;
  
  /**
   * Default value of property <code>selectionMode</code>.
   */
  public static final WDTableSelectionMode DEFAULT_SELECTION_MODE = WDTableSelectionMode.AUTO;
  
  /**
   * Default value of property <code>visibleRowCount</code>.
   */
  public static final int DEFAULT_VISIBLE_ROW_COUNT = 5;
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final String DEFAULT_WIDTH = "";

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the Table (it's like a title) in the accessibility mode. Should be used if no title is available. If you set both, title and accessibilityDescription, only the accessibilityDescription is considered. It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: dataSource, Visibility: private, Type: Object
     convertible: false
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>dataSource</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the dataSource
   *                property is bound
   */
  public void bindDataSource(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>dataSource</code> to the context node
   * specified by the given node info.
   *
   * @param nodeInfo  the info of the context node to which the
   *                  dataSource property is bound
   */
  public void bindDataSource(IWDNodeInfo nodeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>dataSource</code>.
   *
   * @return        the path of the context attribute to which the dataSource
   *                is currently bound
   */
  public String bindingOfDataSource();

  /* Bound Property
     Name: design, Visibility: public, Type: TableDesign, Initial value: standard
     convertible: false
  */

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the design
   *                property is bound
   */
  public void bindDesign(String path);

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       design property is bound
   */
  public void bindDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>design</code>.
   *
   * @return        the path of the context attribute to which the design
   *                is currently bound
   */
  public String bindingOfDesign();

  /**
   * Returns the value of the <code>design</code> property.
   * The initial value is <code>WDTableDesign.STANDARD</code>.
   *
   * Determines the visual design of the table.
   *
   * @return      the current value of the design property
   * @see #setDesign(WDTableDesign)
   */
  public WDTableDesign getDesign();

  /**
   * Sets property <code>design</code> to the new value.
   *
   * @param value     the new value of the design property
   * @see #getDesign()
   */
  public void setDesign(WDTableDesign value);

  /* Bound Property
     Name: firstVisibleRow, Visibility: public, Type: Integer, Initial value: 0
     convertible: false
  */

  /**
   * Binds property <code>firstVisibleRow</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the firstVisibleRow
   *                property is bound
   */
  public void bindFirstVisibleRow(String path);

  /**
   * Binds property <code>firstVisibleRow</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       firstVisibleRow property is bound
   */
  public void bindFirstVisibleRow(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>firstVisibleRow</code>.
   *
   * @return        the path of the context attribute to which the firstVisibleRow
   *                is currently bound
   */
  public String bindingOfFirstVisibleRow();

  /**
   * Returns the value of the <code>firstVisibleRow</code> property.
   * The initial value is <code>0</code>.
   *
   * Determines which row should be the first visible, counts from zero.
   *
   * @return      the current value of the firstVisibleRow property
   * @see #setFirstVisibleRow(int)
   */
  public int getFirstVisibleRow();

  /**
   * Sets property <code>firstVisibleRow</code> to the new value.
   *
   * @param value     the new value of the firstVisibleRow property
   * @see #getFirstVisibleRow()
   */
  public void setFirstVisibleRow(int value);

  /* Bound Property
     Name: footerVisible, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>footerVisible</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the footerVisible
   *                property is bound
   */
  public void bindFooterVisible(String path);

  /**
   * Binds property <code>footerVisible</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       footerVisible property is bound
   */
  public void bindFooterVisible(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>footerVisible</code>.
   *
   * @return        the path of the context attribute to which the footerVisible
   *                is currently bound
   */
  public String bindingOfFooterVisible();

  /**
   * Returns the value of the <code>footerVisible</code> property.
   * The initial value is <code>true</code>.
   *
   * Determines if the table footer is displayed.
   *
   * @return      the current value of the footerVisible property
   * @see #setFooterVisible(boolean)
   */
  public boolean getFooterVisible();

  /**
   * Sets property <code>footerVisible</code> to the new value.
   *
   * @param value     the new value of the footerVisible property
   * @see #getFooterVisible()
   */
  public void setFooterVisible(boolean value);

  /* Bound Property
     Name: readOnly, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the readOnly
   *                property is bound
   */
  public void bindReadOnly(String path);

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       readOnly property is bound
   */
  public void bindReadOnly(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>readOnly</code>.
   *
   * @return        the path of the context attribute to which the readOnly
   *                is currently bound
   */
  public String bindingOfReadOnly();

  /**
   * Returns the value of the <code>readOnly</code> property.
   * The initial value is <code>false</code>.
   *
   * Determines if the table is editable. If set to <code>true</code> editing data in the table is disabled.
   *
   * @return      the current value of the readOnly property
   * @see #setReadOnly(boolean)
   */
  public boolean getReadOnly();

  /**
   * Sets property <code>readOnly</code> to the new value.
   *
   * @param value     the new value of the readOnly property
   * @see #getReadOnly()
   */
  public void setReadOnly(boolean value);

  /* Property
     Name: selectionMode, Visibility: public, Type: TableSelectionMode, Initial value: auto
  */

  /**
   * Returns the value of the <code>selectionMode</code> property.
   * The initial value is <code>WDTableSelectionMode.AUTO</code>.
   *
   * Determines how table rows can be selected.
   *
   * @return the value of the selectionMode property
   * @see #setSelectionMode(WDTableSelectionMode)
   */
  public WDTableSelectionMode getSelectionMode();

  /**
   * Sets property <code>selectionMode</code> to the given value.
   *
   * @param selectionMode  the new selectionMode value
   * @see #getSelectionMode()
   */
  public void setSelectionMode(WDTableSelectionMode selectionMode);

  /* Bound Property
     Name: visibleRowCount, Visibility: public, Type: Integer, Initial value: 5
     convertible: false
  */

  /**
   * Binds property <code>visibleRowCount</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the visibleRowCount
   *                property is bound
   */
  public void bindVisibleRowCount(String path);

  /**
   * Binds property <code>visibleRowCount</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       visibleRowCount property is bound
   */
  public void bindVisibleRowCount(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>visibleRowCount</code>.
   *
   * @return        the path of the context attribute to which the visibleRowCount
   *                is currently bound
   */
  public String bindingOfVisibleRowCount();

  /**
   * Returns the value of the <code>visibleRowCount</code> property.
   * The initial value is <code>5</code>.
   *
   * The number of rows that should be visible without scrolling; a value of -1 means "unlimited" and displays all rows without scrolling.
   *
   * @return      the current value of the visibleRowCount property
   * @see #setVisibleRowCount(int)
   */
  public int getVisibleRowCount();

  /**
   * Sets property <code>visibleRowCount</code> to the new value.
   *
   * @param value     the new value of the visibleRowCount property
   * @see #getVisibleRowCount()
   */
  public void setVisibleRowCount(int value);

  /* Bound Property
     Name: width, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the width
   *                property is bound
   */
  public void bindWidth(String path);

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       width property is bound
   */
  public void bindWidth(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>width</code>.
   *
   * @return        the path of the context attribute to which the width
   *                is currently bound
   */
  public String bindingOfWidth();

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>""</code>.
   *
   * The width (CSS size) of the table.
   *
   * @return      the current value of the width property
   * @see #setWidth(String)
   */
  public String getWidth();

  /**
   * Sets property <code>width</code> to the new value.
   *
   * @param value     the new value of the width property
   * @see #getWidth()
   */
  public void setWidth(String value);

  /* outgoing aggregation:
     Name=Table.Columns, isAbstract=false
Role A: Name=Columns, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=Table, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Column at the end of the list of Columns.
   *
   * @param aTableColumn     the Column to be added into the list
   * @see #getColumns()
   */
  public void addColumn(IWDTableColumn aTableColumn);

  /**
   * Adds the given Column at the specified index in the list of Columns.
   *
   * @param aTableColumn     the Column to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getColumns()
   */
  public void addColumn(IWDTableColumn aTableColumn, int index);

  /**
   * Swaps the Columns at the given indices.
   * 
   * @param i index of the first Column to swap
   * @param j index of the second Column to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapColumns(int i, int j); 
   
  /**
   * Returns the list of Columns.
   *
   * A table contains a number of table columns.
   *
   * @return      an array containing references to the current Columns
   */
  public IWDTableColumn[] getColumns();

  /**
   * Returns the Column at the given index.
   *
   * @return Column at the given index
   */
  public IWDTableColumn getColumn(int index);

  /**
   * Returns the index of the given element in the list of Columns
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfColumn(IWDTableColumn aTableColumn);
       
  /**
   * Returns the number of Columns.
   * 
   * @return the current number of Columns.
   * @see #getColumns()
   */
  public int numberOfColumns();
  
  /**
   * Checks if there exist Columns.
   *
   * @return      <code>true</code> if there are Columns;
   *              <code>false</code> otherwise.
   * @see #getColumns()
   */
  public boolean hasColumns();

  /**
   * Returns an iterator over the list of Columns.
   *
   * @return      an iterator over the current Columns
   * @see #getColumns()
   */
  public Iterator iterateColumns();

  /**
   * Removes the entry at the given index from the list of Columns.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addColumn(IWDTableColumn)
   * @see #getColumns()
   */
  public IWDTableColumn removeColumn(int index);

  /**
   * Removes the entry with the given ID from the list of Columns.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addColumn(IWDTableColumn)
   * @see #getColumns()
   */
  public IWDTableColumn removeColumn(String id);

  /**
   * Removes all entries from the list of Columns.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addColumn(IWDTableColumn)
   * @see #getColumns()
   */
  public void removeAllColumns(); 

  /**
   * Destroys all entries in the list of Columns.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllColumns();

  /* outgoing aggregation:
     Name=Table.Header, isAbstract=false
Role A: Name=Header, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Table, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Header instance.
   *
   * The header of a table contains a caption.
   *
   * @return      the current Header
   * @see #setHeader(IWDCaption)
   */
  public IWDCaption getHeader();

  /**
   * Sets the Header instance.
   *
   * @param header    the new header
   * @see #getHeader()
   */
  public void setHeader(IWDCaption header);

  /**
   * Destroys the Header instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyHeader();

  /* outgoing aggregation:
     Name=Table.MasterColumn, isAbstract=false
Role A: Name=MasterColumn, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Table, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the MasterColumn instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current MasterColumn
   * @see #setMasterColumn(IWDAbstractMasterTableColumn)
   */
  public IWDAbstractMasterTableColumn getMasterColumn();

  /**
   * Sets the MasterColumn instance.
   *
   * @param masterColumn    the new masterColumn
   * @see #getMasterColumn()
   */
  public void setMasterColumn(IWDAbstractMasterTableColumn masterColumn);

  /**
   * Destroys the MasterColumn instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyMasterColumn();

  /* outgoing aggregation:
     Name=Table.ToolBar, isAbstract=false
Role A: Name=ToolBar, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=Table, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the ToolBar instance.
   *
   * A table may contain a toolbar.
   *
   * @return      the current ToolBar
   * @see #setToolBar(IWDToolBar)
   */
  public IWDToolBar getToolBar();

  /**
   * Sets the ToolBar instance.
   *
   * @param toolBar    the new toolBar
   * @see #getToolBar()
   */
  public void setToolBar(IWDToolBar toolBar);

  /**
   * Destroys the ToolBar instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyToolBar();

//@@begin extensions
//@@end

}
