
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDTabStrip.java#6 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro TabStrip API.
 *
 * TabStrip is used to display a set of data organized in tabs.
 * One tab at a time may be selected and its content by displayed.
 * A tab is selected by clicking its caption.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDTab
 * @SAPWebDynproPart 2
 */
public interface IWDTabStrip extends IWDUIElement
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when a tab is selected.
   * Event parameter is the ID of the selected tab.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String tab - The ID of the selected tab.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>height</code>.
   */
  public static final String DEFAULT_HEIGHT = "";
  
  /**
   * Default value of property <code>selectedTab</code>.
   */
  public static final String DEFAULT_SELECTED_TAB = "";
  
  /**
   * Default value of property <code>tabAlignment</code>.
   */
  public static final WDTabAlignment DEFAULT_TAB_ALIGNMENT = WDTabAlignment.FAST;
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final String DEFAULT_WIDTH = "";

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the TabStrip (It's like a title) in the accessibility mode.  It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: height, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>height</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the height
   *                property is bound
   */
  public void bindHeight(String path);

  /**
   * Binds property <code>height</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       height property is bound
   */
  public void bindHeight(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>height</code>.
   *
   * @return        the path of the context attribute to which the height
   *                is currently bound
   */
  public String bindingOfHeight();

  /**
   * Returns the value of the <code>height</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the height (CSS size) of the tab strip and its tabs.
   *
   * @return      the current value of the height property
   * @see #setHeight(String)
   */
  public String getHeight();

  /**
   * Sets property <code>height</code> to the new value.
   *
   * @param value     the new value of the height property
   * @see #getHeight()
   */
  public void setHeight(String value);

  /* Bound Property
     Name: selectedTab, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>selectedTab</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedTab
   *                property is bound
   */
  public void bindSelectedTab(String path);

  /**
   * Binds property <code>selectedTab</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedTab property is bound
   */
  public void bindSelectedTab(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>selectedTab</code>.
   *
   * @return        the path of the context attribute to which the selectedTab
   *                is currently bound
   */
  public String bindingOfSelectedTab();

  /**
   * Returns the value of the <code>selectedTab</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the currently selected tab.
   *
   * @return      the current value of the selectedTab property
   * @see #setSelectedTab(String)
   */
  public String getSelectedTab();

  /**
   * Sets property <code>selectedTab</code> to the new value.
   *
   * @param value     the new value of the selectedTab property
   * @see #getSelectedTab()
   */
  public void setSelectedTab(String value);

  /* Property
     Name: tabAlignment, Visibility: public, Type: TabAlignment, Initial value: fast
  */

  /**
   * Returns the value of the <code>tabAlignment</code> property.
   * The initial value is <code>WDTabAlignment.FAST</code>.
   *
   * Determines how each tab's width and height are aligned with the other tabs' widths and heights. <b>BEWARE</b> Forcing a browser based client to make all tabs equally wide and high is extremely inefficient.
   *
   * @return the value of the tabAlignment property
   * @see #setTabAlignment(WDTabAlignment)
   */
  public WDTabAlignment getTabAlignment();

  /**
   * Sets property <code>tabAlignment</code> to the given value.
   *
   * @param tabAlignment  the new tabAlignment value
   * @see #getTabAlignment()
   */
  public void setTabAlignment(WDTabAlignment tabAlignment);

  /* Bound Property
     Name: width, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the width
   *                property is bound
   */
  public void bindWidth(String path);

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       width property is bound
   */
  public void bindWidth(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>width</code>.
   *
   * @return        the path of the context attribute to which the width
   *                is currently bound
   */
  public String bindingOfWidth();

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the width (CSS size) of the tab strip and its tabs.
   *
   * @return      the current value of the width property
   * @see #setWidth(String)
   */
  public String getWidth();

  /**
   * Sets property <code>width</code> to the new value.
   *
   * @param value     the new value of the width property
   * @see #getWidth()
   */
  public void setWidth(String value);

  /* outgoing aggregation:
     Name=TabStrip.Tabs, isAbstract=false
Role A: Name=Tabs, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=TabStrip, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Tab at the end of the list of Tabs.
   *
   * @param aTab     the Tab to be added into the list
   * @see #getTabs()
   */
  public void addTab(IWDTab aTab);

  /**
   * Adds the given Tab at the specified index in the list of Tabs.
   *
   * @param aTab     the Tab to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getTabs()
   */
  public void addTab(IWDTab aTab, int index);

  /**
   * Swaps the Tabs at the given indices.
   * 
   * @param i index of the first Tab to swap
   * @param j index of the second Tab to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapTabs(int i, int j); 
   
  /**
   * Returns the list of Tabs.
   *
   * A tab strip consists of a number of tabs.
   *
   * @return      an array containing references to the current Tabs
   */
  public IWDTab[] getTabs();

  /**
   * Returns the Tab at the given index.
   *
   * @return Tab at the given index
   */
  public IWDTab getTab(int index);

  /**
   * Returns the index of the given element in the list of Tabs
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfTab(IWDTab aTab);
       
  /**
   * Returns the number of Tabs.
   * 
   * @return the current number of Tabs.
   * @see #getTabs()
   */
  public int numberOfTabs();
  
  /**
   * Checks if there exist Tabs.
   *
   * @return      <code>true</code> if there are Tabs;
   *              <code>false</code> otherwise.
   * @see #getTabs()
   */
  public boolean hasTabs();

  /**
   * Returns an iterator over the list of Tabs.
   *
   * @return      an iterator over the current Tabs
   * @see #getTabs()
   */
  public Iterator iterateTabs();

  /**
   * Removes the entry at the given index from the list of Tabs.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addTab(IWDTab)
   * @see #getTabs()
   */
  public IWDTab removeTab(int index);

  /**
   * Removes the entry with the given ID from the list of Tabs.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addTab(IWDTab)
   * @see #getTabs()
   */
  public IWDTab removeTab(String id);

  /**
   * Removes all entries from the list of Tabs.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addTab(IWDTab)
   * @see #getTabs()
   */
  public void removeAllTabs(); 

  /**
   * Destroys all entries in the list of Tabs.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllTabs();

//@@begin extensions
//@@end

}
