
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDRoadMap.java#5 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro RoadMap API.
 *
 * Visualizes the steps in a wizard.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDRoadMap extends IWDUIElement
{

  // Event "onLoadSteps"
  
  /**
   * Returns the action to which the event <code>onLoadSteps</code> is mapped.
   *
   * The action performed when the RoadMap has more steps as currently displayed (startPointDesign-->more or endPointDesign-->more) and the users clicks an the more-steps icon.
   * Event parameter is a boolean and defines if more steps are at the end (true) or the further steps are at the beginning of the RoadMap (false).
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnLoadSteps()
   */
  public IWDAction getOnLoadSteps();

  /**
   * Maps the event <code>onLoadSteps</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnLoadSteps()
   */
  public void setOnLoadSteps(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onLoadSteps</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>boolean atEnd - Event parameter is a boolean and defines if more steps are at the end (true) or the further steps are at the beginning of the RoadMap (false).</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnLoadSteps()
   */  
  public IWDParameterMapping mappingOfOnLoadSteps();
  

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when a step is selected.
   * Event parameter is the ID of the selected step.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String step - The ID of the selected step.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>endPointDesign</code>.
   */
  public static final WDRoadMapEdgeDesign DEFAULT_END_POINT_DESIGN = WDRoadMapEdgeDesign.STANDARD;
  
  /**
   * Default value of property <code>selectedStep</code>.
   */
  public static final String DEFAULT_SELECTED_STEP = "";
  
  /**
   * Default value of property <code>startPointDesign</code>.
   */
  public static final WDRoadMapEdgeDesign DEFAULT_START_POINT_DESIGN = WDRoadMapEdgeDesign.STANDARD;

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the RoadMap (it's like a title) in the accessibility mode.  It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: endPointDesign, Visibility: public, Type: RoadMapEdgeDesign, Initial value: standard
     convertible: false
  */

  /**
   * Binds property <code>endPointDesign</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the endPointDesign
   *                property is bound
   */
  public void bindEndPointDesign(String path);

  /**
   * Binds property <code>endPointDesign</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       endPointDesign property is bound
   */
  public void bindEndPointDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>endPointDesign</code>.
   *
   * @return        the path of the context attribute to which the endPointDesign
   *                is currently bound
   */
  public String bindingOfEndPointDesign();

  /**
   * Returns the value of the <code>endPointDesign</code> property.
   * The initial value is <code>WDRoadMapEdgeDesign.STANDARD</code>.
   *
   * The visual design of the road map's end point.
   *
   * @return      the current value of the endPointDesign property
   * @see #setEndPointDesign(WDRoadMapEdgeDesign)
   */
  public WDRoadMapEdgeDesign getEndPointDesign();

  /**
   * Sets property <code>endPointDesign</code> to the new value.
   *
   * @param value     the new value of the endPointDesign property
   * @see #getEndPointDesign()
   */
  public void setEndPointDesign(WDRoadMapEdgeDesign value);

  /* Bound Property
     Name: selectedStep, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>selectedStep</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedStep
   *                property is bound
   */
  public void bindSelectedStep(String path);

  /**
   * Binds property <code>selectedStep</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedStep property is bound
   */
  public void bindSelectedStep(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>selectedStep</code>.
   *
   * @return        the path of the context attribute to which the selectedStep
   *                is currently bound
   */
  public String bindingOfSelectedStep();

  /**
   * Returns the value of the <code>selectedStep</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the selected Step.
   *
   * @return      the current value of the selectedStep property
   * @see #setSelectedStep(String)
   */
  public String getSelectedStep();

  /**
   * Sets property <code>selectedStep</code> to the new value.
   *
   * @param value     the new value of the selectedStep property
   * @see #getSelectedStep()
   */
  public void setSelectedStep(String value);

  /* Bound Property
     Name: startPointDesign, Visibility: public, Type: RoadMapEdgeDesign, Initial value: standard
     convertible: false
  */

  /**
   * Binds property <code>startPointDesign</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the startPointDesign
   *                property is bound
   */
  public void bindStartPointDesign(String path);

  /**
   * Binds property <code>startPointDesign</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       startPointDesign property is bound
   */
  public void bindStartPointDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>startPointDesign</code>.
   *
   * @return        the path of the context attribute to which the startPointDesign
   *                is currently bound
   */
  public String bindingOfStartPointDesign();

  /**
   * Returns the value of the <code>startPointDesign</code> property.
   * The initial value is <code>WDRoadMapEdgeDesign.STANDARD</code>.
   *
   * The visual design of the road map's start point.
   *
   * @return      the current value of the startPointDesign property
   * @see #setStartPointDesign(WDRoadMapEdgeDesign)
   */
  public WDRoadMapEdgeDesign getStartPointDesign();

  /**
   * Sets property <code>startPointDesign</code> to the new value.
   *
   * @param value     the new value of the startPointDesign property
   * @see #getStartPointDesign()
   */
  public void setStartPointDesign(WDRoadMapEdgeDesign value);

  /* outgoing aggregation:
     Name=RoadMap.Steps, isAbstract=false
Role A: Name=Steps, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=RoadMap, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Step at the end of the list of Steps.
   *
   * @param aRoadMapStep     the Step to be added into the list
   * @see #getSteps()
   */
  public void addStep(IWDRoadMapStep aRoadMapStep);

  /**
   * Adds the given Step at the specified index in the list of Steps.
   *
   * @param aRoadMapStep     the Step to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getSteps()
   */
  public void addStep(IWDRoadMapStep aRoadMapStep, int index);

  /**
   * Swaps the Steps at the given indices.
   * 
   * @param i index of the first Step to swap
   * @param j index of the second Step to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapSteps(int i, int j); 
   
  /**
   * Returns the list of Steps.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Steps
   */
  public IWDRoadMapStep[] getSteps();

  /**
   * Returns the Step at the given index.
   *
   * @return Step at the given index
   */
  public IWDRoadMapStep getStep(int index);

  /**
   * Returns the index of the given element in the list of Steps
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfStep(IWDRoadMapStep aRoadMapStep);
       
  /**
   * Returns the number of Steps.
   * 
   * @return the current number of Steps.
   * @see #getSteps()
   */
  public int numberOfSteps();
  
  /**
   * Checks if there exist Steps.
   *
   * @return      <code>true</code> if there are Steps;
   *              <code>false</code> otherwise.
   * @see #getSteps()
   */
  public boolean hasSteps();

  /**
   * Returns an iterator over the list of Steps.
   *
   * @return      an iterator over the current Steps
   * @see #getSteps()
   */
  public Iterator iterateSteps();

  /**
   * Removes the entry at the given index from the list of Steps.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addStep(IWDRoadMapStep)
   * @see #getSteps()
   */
  public IWDRoadMapStep removeStep(int index);

  /**
   * Removes the entry with the given ID from the list of Steps.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addStep(IWDRoadMapStep)
   * @see #getSteps()
   */
  public IWDRoadMapStep removeStep(String id);

  /**
   * Removes all entries from the list of Steps.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addStep(IWDRoadMapStep)
   * @see #getSteps()
   */
  public void removeAllSteps(); 

  /**
   * Destroys all entries in the list of Steps.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllSteps();

//@@begin extensions
//@@end

}
