
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDPhaseIndicator.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro PhaseIndicator API.
 *
 * Visualizes the steps in a wizard.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDPhaseIndicator extends IWDUIElement
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when a phase is selected.
   * Event parameter is the ID of the selected phase.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String phase - The ID of the selected phase.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>backgroundDesign</code>.
   */
  public static final WDPhaseIndicatorBackgroundDesign DEFAULT_BACKGROUND_DESIGN = WDPhaseIndicatorBackgroundDesign.EMPHASIZED;
  
  /**
   * Default value of property <code>firstVisiblePhase</code>.
   */
  public static final String DEFAULT_FIRST_VISIBLE_PHASE = "";
  
  /**
   * Default value of property <code>selectedPhase</code>.
   */
  public static final String DEFAULT_SELECTED_PHASE = "";

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the PhaseIndicator (it's like a title) in the accessibility mode. It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: backgroundDesign, Visibility: public, Type: PhaseIndicatorBackgroundDesign, Initial value: emphasized
     convertible: false
  */

  /**
   * Binds property <code>backgroundDesign</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the backgroundDesign
   *                property is bound
   */
  public void bindBackgroundDesign(String path);

  /**
   * Binds property <code>backgroundDesign</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       backgroundDesign property is bound
   */
  public void bindBackgroundDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>backgroundDesign</code>.
   *
   * @return        the path of the context attribute to which the backgroundDesign
   *                is currently bound
   */
  public String bindingOfBackgroundDesign();

  /**
   * Returns the value of the <code>backgroundDesign</code> property.
   * The initial value is <code>WDPhaseIndicatorBackgroundDesign.EMPHASIZED</code>.
   *
   * Defines the background color of a PhaseIndicator.
   *
   * @return      the current value of the backgroundDesign property
   * @see #setBackgroundDesign(WDPhaseIndicatorBackgroundDesign)
   */
  public WDPhaseIndicatorBackgroundDesign getBackgroundDesign();

  /**
   * Sets property <code>backgroundDesign</code> to the new value.
   *
   * @param value     the new value of the backgroundDesign property
   * @see #getBackgroundDesign()
   */
  public void setBackgroundDesign(WDPhaseIndicatorBackgroundDesign value);

  /* Bound Property
     Name: firstVisiblePhase, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>firstVisiblePhase</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the firstVisiblePhase
   *                property is bound
   */
  public void bindFirstVisiblePhase(String path);

  /**
   * Binds property <code>firstVisiblePhase</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       firstVisiblePhase property is bound
   */
  public void bindFirstVisiblePhase(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>firstVisiblePhase</code>.
   *
   * @return        the path of the context attribute to which the firstVisiblePhase
   *                is currently bound
   */
  public String bindingOfFirstVisiblePhase();

  /**
   * Returns the value of the <code>firstVisiblePhase</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the first visible Phase.
   *
   * @return      the current value of the firstVisiblePhase property
   * @see #setFirstVisiblePhase(String)
   */
  public String getFirstVisiblePhase();

  /**
   * Sets property <code>firstVisiblePhase</code> to the new value.
   *
   * @param value     the new value of the firstVisiblePhase property
   * @see #getFirstVisiblePhase()
   */
  public void setFirstVisiblePhase(String value);

  /* Bound Property
     Name: selectedPhase, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>selectedPhase</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedPhase
   *                property is bound
   */
  public void bindSelectedPhase(String path);

  /**
   * Binds property <code>selectedPhase</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedPhase property is bound
   */
  public void bindSelectedPhase(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>selectedPhase</code>.
   *
   * @return        the path of the context attribute to which the selectedPhase
   *                is currently bound
   */
  public String bindingOfSelectedPhase();

  /**
   * Returns the value of the <code>selectedPhase</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the selected Phase.
   *
   * @return      the current value of the selectedPhase property
   * @see #setSelectedPhase(String)
   */
  public String getSelectedPhase();

  /**
   * Sets property <code>selectedPhase</code> to the new value.
   *
   * @param value     the new value of the selectedPhase property
   * @see #getSelectedPhase()
   */
  public void setSelectedPhase(String value);

  /* outgoing aggregation:
     Name=PhaseIndicator.Phases, isAbstract=false
Role A: Name=Phases, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PhaseIndicator, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Phase at the end of the list of Phases.
   *
   * @param aPhase     the Phase to be added into the list
   * @see #getPhases()
   */
  public void addPhase(IWDPhase aPhase);

  /**
   * Adds the given Phase at the specified index in the list of Phases.
   *
   * @param aPhase     the Phase to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getPhases()
   */
  public void addPhase(IWDPhase aPhase, int index);

  /**
   * Swaps the Phases at the given indices.
   * 
   * @param i index of the first Phase to swap
   * @param j index of the second Phase to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapPhases(int i, int j); 
   
  /**
   * Returns the list of Phases.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Phases
   */
  public IWDPhase[] getPhases();

  /**
   * Returns the Phase at the given index.
   *
   * @return Phase at the given index
   */
  public IWDPhase getPhase(int index);

  /**
   * Returns the index of the given element in the list of Phases
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfPhase(IWDPhase aPhase);
       
  /**
   * Returns the number of Phases.
   * 
   * @return the current number of Phases.
   * @see #getPhases()
   */
  public int numberOfPhases();
  
  /**
   * Checks if there exist Phases.
   *
   * @return      <code>true</code> if there are Phases;
   *              <code>false</code> otherwise.
   * @see #getPhases()
   */
  public boolean hasPhases();

  /**
   * Returns an iterator over the list of Phases.
   *
   * @return      an iterator over the current Phases
   * @see #getPhases()
   */
  public Iterator iteratePhases();

  /**
   * Removes the entry at the given index from the list of Phases.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addPhase(IWDPhase)
   * @see #getPhases()
   */
  public IWDPhase removePhase(int index);

  /**
   * Removes the entry with the given ID from the list of Phases.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addPhase(IWDPhase)
   * @see #getPhases()
   */
  public IWDPhase removePhase(String id);

  /**
   * Removes all entries from the list of Phases.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addPhase(IWDPhase)
   * @see #getPhases()
   */
  public void removeAllPhases(); 

  /**
   * Destroys all entries in the list of Phases.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllPhases();

//@@begin extensions
//@@end

}
