
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDMatrixLayout.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro MatrixLayout API.
 *
 * The matrix layout arranges UI elements in a grid structure. It uses predefined cell classes that guarantee appropriate distances between cells in the grid. The vGutter property lets you specify additional horizontal distances easily. You can set these additional distances (known as gutters) with or without separators. In addition, the matrix layout can include horizontal separators to separate the rows further, represented by the HorizontalGutter UI element. The distance for each cell is specified by assigning a specific enumeration value of the class WDLayoutCellSeparator of the matrix data object. This type of layout is preferable to the GridLayout, since it makes the layout structure in a container more consistent. Using the interface IWDMatrixHeadData, you can specify the UI element that appears at the start of each new line.
 * 
 * You should avoid using nested matrix layouts. Instead, use row layouts wherever possible. The row layout differs from the matrix layout in that the content is not organized in table cells. That is, the individual elements are not aligned vertically with each other. When the row layout is implemented in an application, performance is better than if a matrix layout were used, but the layout flexibility is not compromised. For this reason, you should structure the view and container in horizontal areas as early as possible, using the row layout. You should only use the matrix layout if you need to display a table and align the elements vertically.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDMatrixLayout extends IWDLayout
{
  
  /**
   * Default value of property <code>stretchedHorizontally</code>.
   */
  public static final boolean DEFAULT_STRETCHED_HORIZONTALLY = true;
  
  /**
   * Default value of property <code>stretchedVertically</code>.
   */
  public static final boolean DEFAULT_STRETCHED_VERTICALLY = true;

  /* Property
     Name: stretchedHorizontally, Visibility: public, Type: Boolean, Initial value: true
  */

  /**
   * Returns the value of the <code>stretchedHorizontally</code> property.
   * The initial value is <code>true</code>.
   *
   * Specifies whether UI elements aligned using this layout are adapted horizontally to the container size, so that the container is completely filled horizontally.
   *
   * @return the value of the stretchedHorizontally property
   * @see #setStretchedHorizontally(boolean)
   */
  public boolean getStretchedHorizontally();

  /**
   * Sets property <code>stretchedHorizontally</code> to the given value.
   *
   * @param stretchedHorizontally  the new stretchedHorizontally value
   * @see #getStretchedHorizontally()
   */
  public void setStretchedHorizontally(boolean stretchedHorizontally);

  /* Property
     Name: stretchedVertically, Visibility: public, Type: Boolean, Initial value: true
  */

  /**
   * Returns the value of the <code>stretchedVertically</code> property.
   * The initial value is <code>true</code>.
   *
   * Specifies whether UI elements aligned using this layout are adapted vertically to the container size, so that the container is completely filled vertically.
   *
   * @return the value of the stretchedVertically property
   * @see #setStretchedVertically(boolean)
   */
  public boolean getStretchedVertically();

  /**
   * Sets property <code>stretchedVertically</code> to the given value.
   *
   * @param stretchedVertically  the new stretchedVertically value
   * @see #getStretchedVertically()
   */
  public void setStretchedVertically(boolean stretchedVertically);

//@@begin extensions
//@@end

}

// ---- content of obsolete user coding area(s) ----
//@@begin obsolete:MatrixLayout_begin
//@@end
