
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDDateNavigatorMarking.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro DateNavigatorMarking API.
 *
 * Attach a marking to a date navigator if you want to mark one or more dates with a category and a tooltip.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDDateNavigatorMarking extends IWDViewElement
{
  
  /**
   * Default value of property <code>category</code>.
   */
  public static final WDDateMarkingCategory DEFAULT_CATEGORY = WDDateMarkingCategory.ONE;
  
  /**
   * Default value of property <code>tooltip</code>.
   */
  public static final String DEFAULT_TOOLTIP = "";

  /* Bound Property
     Name: category, Visibility: public, Type: DateMarkingCategory, Initial value: one
     convertible: false
  */

  /**
   * Binds property <code>category</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the category
   *                property is bound
   */
  public void bindCategory(String path);

  /**
   * Binds property <code>category</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       category property is bound
   */
  public void bindCategory(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>category</code>.
   *
   * @return        the path of the context attribute to which the category
   *                is currently bound
   */
  public String bindingOfCategory();

  /**
   * Returns the value of the <code>category</code> property.
   * The initial value is <code>WDDateMarkingCategory.ONE</code>.
   *
   * The marking's category determines how the date in question is marked (visually etc.). Several date markings may well share the same category.
   * If this property is not bound to an attribute of the multiple context node that the "dataSource" property is bound to, then the category is the same for all markings.
   *
   * @return      the current value of the category property
   * @see #setCategory(WDDateMarkingCategory)
   */
  public WDDateMarkingCategory getCategory();

  /**
   * Sets property <code>category</code> to the new value.
   *
   * @param value     the new value of the category property
   * @see #getCategory()
   */
  public void setCategory(WDDateMarkingCategory value);

  /* Bound Property
     Name: dataSource, Visibility: private, Type: Object
     convertible: false
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>dataSource</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the dataSource
   *                property is bound
   */
  public void bindDataSource(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>dataSource</code> to the context node
   * specified by the given node info.
   *
   * @param nodeInfo  the info of the context node to which the
   *                  dataSource property is bound
   */
  public void bindDataSource(IWDNodeInfo nodeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>dataSource</code>.
   *
   * @return        the path of the context attribute to which the dataSource
   *                is currently bound
   */
  public String bindingOfDataSource();

  /* Bound Property
     Name: date, Visibility: public, Type: Date
     convertible: false
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>date</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the date
   *                property is bound
   */
  public void bindDate(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>date</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       date property is bound
   */
  public void bindDate(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>date</code>.
   *
   * @return        the path of the context attribute to which the date
   *                is currently bound
   */
  public String bindingOfDate();

  /* Bound Property
     Name: tooltip, Visibility: public, Type: TranslatableText
     convertible: true
  */

  /**
   * Binds property <code>tooltip</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the tooltip
   *                property is bound
   */
  public void bindTooltip(String path);

  /**
   * Binds property <code>tooltip</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       tooltip property is bound
   */
  public void bindTooltip(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>tooltip</code>.
   *
   * @return        the path of the context attribute to which the tooltip
   *                is currently bound
   */
  public String bindingOfTooltip();

  /**
   * Returns the value of the <code>tooltip</code> property.
   * The initial value is <code>""</code>.
   *
   * The marking's tooltip.
   * If this property is not bound to an attribute of the multiple context node that the "dataSource" property is bound to, then the tooltip is the same for all markings.
   *
   * @return      the current value of the tooltip property
   * @see #setTooltip(String)
   */
  public String getTooltip();

  /**
   * Sets property <code>tooltip</code> to the new value.
   *
   * @param value     the new value of the tooltip property
   * @see #getTooltip()
   */
  public void setTooltip(String value);

  /* incoming aggregation:
     Name=DateNavigator.Marking, isAbstract=false
Role A: Name=Marking, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=DateNavigator, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Returns the current DateNavigator.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current DateNavigator
   */
  public IWDDateNavigator getDateNavigator();

//@@begin extensions
//@@end

}
