
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDCheckBoxGroup.java#4 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro CheckBoxGroup API.
 *
 * CheckBoxGroup represents a multiple selection visualized
 * by a group of check boxes.
 * <p>
 * <strong>Data binding:</strong>
 * <br>
 * The context must provide a node <code>X</code> with <code>X.cardinality = 0..n</code>
 * and <code>X.selection = 0..n</code> with an attribute <code>y</code>. The type of <code>y</code> must be a simple type like <code>String</code>.
 * The number of check boxes is the number of node elements, their texts are the values of attribute <code>y</code>,
 * and the selection of the check boxes is determined by the (multiple) selection of the node.
 * <p>
 * The property <code>texts</code> must be bound to the attribute <code>y</code>.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDCheckBoxGroup extends IWDUIElement
{

  // Event "onToggle"
  
  /**
   * Returns the action to which the event <code>onToggle</code> is mapped.
   *
   * The action performed when a check box in this group is toggled.
   * Event parameters are the new checked value and the zero based
   * index of the toggled check box.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnToggle()
   */
  public IWDAction getOnToggle();

  /**
   * Maps the event <code>onToggle</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnToggle()
   */
  public void setOnToggle(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onToggle</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>boolean checked - The new checked value of the toggled check box.</li>
   * <li>int index - The zero based index of the toggled check box.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnToggle()
   */  
  public IWDParameterMapping mappingOfOnToggle();
  
  
  /**
   * Default value of property <code>accessibilityDescription</code>.
   */
  public static final String DEFAULT_ACCESSIBILITY_DESCRIPTION = "";
  
  /**
   * Default value of property <code>colCount</code>.
   */
  public static final int DEFAULT_COL_COUNT = 1;
  
  /**
   * Default value of property <code>readOnly</code>.
   */
  public static final boolean DEFAULT_READ_ONLY = false;
  
  /**
   * Default value of property <code>state</code>.
   */
  public static final WDState DEFAULT_STATE = WDState.NORMAL;
  
  /**
   * Default value of property <code>textDirection</code>.
   */
  public static final WDTextDirection DEFAULT_TEXT_DIRECTION = WDTextDirection.INHERIT;
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final String DEFAULT_WIDTH = "";

  /* Bound Property
     Name: accessibilityDescription, Visibility: public, Type: TranslatableText
     convertible: false
  */

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the accessibilityDescription
   *                property is bound
   */
  public void bindAccessibilityDescription(String path);

  /**
   * Binds property <code>accessibilityDescription</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       accessibilityDescription property is bound
   */
  public void bindAccessibilityDescription(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>accessibilityDescription</code>.
   *
   * @return        the path of the context attribute to which the accessibilityDescription
   *                is currently bound
   */
  public String bindingOfAccessibilityDescription();

  /**
   * Returns the value of the <code>accessibilityDescription</code> property.
   * The initial value is <code>""</code>.
   *
   * Short description for the CheckBoxGroup (it's like a title) in the accessibility mode.  It is only used if accessibility mode (508) is switched on and will be included into the tooltip. Its read by the screen reader when the whole UI element gets the focus.
   *
   * @return      the current value of the accessibilityDescription property
   * @see #setAccessibilityDescription(String)
   */
  public String getAccessibilityDescription();

  /**
   * Sets property <code>accessibilityDescription</code> to the new value.
   *
   * @param value     the new value of the accessibilityDescription property
   * @see #getAccessibilityDescription()
   */
  public void setAccessibilityDescription(String value);

  /* Bound Property
     Name: colCount, Visibility: public, Type: Integer, Initial value: 1
     convertible: false
  */

  /**
   * Binds property <code>colCount</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the colCount
   *                property is bound
   */
  public void bindColCount(String path);

  /**
   * Binds property <code>colCount</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       colCount property is bound
   */
  public void bindColCount(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>colCount</code>.
   *
   * @return        the path of the context attribute to which the colCount
   *                is currently bound
   */
  public String bindingOfColCount();

  /**
   * Returns the value of the <code>colCount</code> property.
   * The initial value is <code>1</code>.
   *
   * Determines the number of columns used to display the check boxes.
   *
   * @return      the current value of the colCount property
   * @see #setColCount(int)
   */
  public int getColCount();

  /**
   * Sets property <code>colCount</code> to the new value.
   *
   * @param value     the new value of the colCount property
   * @see #getColCount()
   */
  public void setColCount(int value);

  /* Bound Property
     Name: readOnly, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the readOnly
   *                property is bound
   */
  public void bindReadOnly(String path);

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       readOnly property is bound
   */
  public void bindReadOnly(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>readOnly</code>.
   *
   * @return        the path of the context attribute to which the readOnly
   *                is currently bound
   */
  public String bindingOfReadOnly();

  /**
   * Returns the value of the <code>readOnly</code> property.
   * The initial value is <code>false</code>.
   *
   * Controls whether the check boxes in this group may be toggled.
   *
   * @return      the current value of the readOnly property
   * @see #setReadOnly(boolean)
   */
  public boolean getReadOnly();

  /**
   * Sets property <code>readOnly</code> to the new value.
   *
   * @param value     the new value of the readOnly property
   * @see #getReadOnly()
   */
  public void setReadOnly(boolean value);

  /* Bound Property
     Name: state, Visibility: public, Type: State, Initial value: normal
     convertible: false
  */

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the state
   *                property is bound
   */
  public void bindState(String path);

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       state property is bound
   */
  public void bindState(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>state</code>.
   *
   * @return        the path of the context attribute to which the state
   *                is currently bound
   */
  public String bindingOfState();

  /**
   * Returns the value of the <code>state</code> property.
   * The initial value is <code>WDState.NORMAL</code>.
   *
   * The state of the check box group.
   *
   * @return      the current value of the state property
   * @see #setState(WDState)
   */
  public WDState getState();

  /**
   * Sets property <code>state</code> to the new value.
   *
   * @param value     the new value of the state property
   * @see #getState()
   */
  public void setState(WDState value);

  /* Bound Property
     Name: textDirection, Visibility: public, Type: TextDirection, Initial value: inherit
     convertible: false
  */

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the textDirection
   *                property is bound
   */
  public void bindTextDirection(String path);

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       textDirection property is bound
   */
  public void bindTextDirection(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>textDirection</code>.
   *
   * @return        the path of the context attribute to which the textDirection
   *                is currently bound
   */
  public String bindingOfTextDirection();

  /**
   * Returns the value of the <code>textDirection</code> property.
   * The initial value is <code>WDTextDirection.INHERIT</code>.
   *
   * Determines the direction of displayed text.
   *
   * @return      the current value of the textDirection property
   * @see #setTextDirection(WDTextDirection)
   */
  public WDTextDirection getTextDirection();

  /**
   * Sets property <code>textDirection</code> to the new value.
   *
   * @param value     the new value of the textDirection property
   * @see #getTextDirection()
   */
  public void setTextDirection(WDTextDirection value);

  /* Bound Property
     Name: texts, Visibility: private, Type: String
     convertible: true
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>texts</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the texts
   *                property is bound
   */
  public void bindTexts(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>texts</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       texts property is bound
   */
  public void bindTexts(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>texts</code>.
   *
   * @return        the path of the context attribute to which the texts
   *                is currently bound
   */
  public String bindingOfTexts();

  /* Bound Property
     Name: width, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the width
   *                property is bound
   */
  public void bindWidth(String path);

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       width property is bound
   */
  public void bindWidth(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>width</code>.
   *
   * @return        the path of the context attribute to which the width
   *                is currently bound
   */
  public String bindingOfWidth();

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the (minimal) width of the CheckBoxGroup specified as CSS size.
   *
   * @return      the current value of the width property
   * @see #setWidth(String)
   */
  public String getWidth();

  /**
   * Sets property <code>width</code> to the new value.
   *
   * @param value     the new value of the width property
   * @see #getWidth()
   */
  public void setWidth(String value);

//@@begin extensions
//@@end

}
