
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDCheckBox.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro CheckBox API.
 *
 * CheckBox displays a boolean value together with a text. By checking the box the boolean value is set to <code>true</code>.
 * The property <code>checked</code> contains the value, <code>text</code>
 * contains the displayed text.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDCheckBox extends IWDUIElement, IWDTableCellEditor
{

  // Event "onToggle"
  
  /**
   * Returns the action to which the event <code>onToggle</code> is mapped.
   *
   * The action performed when the check box is toggled.
   * The event parameter is the new checked state.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnToggle()
   */
  public IWDAction getOnToggle();

  /**
   * Maps the event <code>onToggle</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnToggle()
   */
  public void setOnToggle(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onToggle</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>boolean checked - The new state of the check box, true if checked.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnToggle()
   */  
  public IWDParameterMapping mappingOfOnToggle();
  
  
  /**
   * Default value of property <code>readOnly</code>.
   */
  public static final boolean DEFAULT_READ_ONLY = false;
  
  /**
   * Default value of property <code>state</code>.
   */
  public static final WDState DEFAULT_STATE = WDState.NORMAL;
  
  /**
   * Default value of property <code>text</code>.
   */
  public static final String DEFAULT_TEXT = "";
  
  /**
   * Default value of property <code>textDirection</code>.
   */
  public static final WDTextDirection DEFAULT_TEXT_DIRECTION = WDTextDirection.INHERIT;

  /* Bound Property
     Name: checked, Visibility: private, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>checked</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the checked
   *                property is bound
   */
  public void bindChecked(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>checked</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       checked property is bound
   */
  public void bindChecked(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>checked</code>.
   *
   * @return        the path of the context attribute to which the checked
   *                is currently bound
   */
  public String bindingOfChecked();

  /**
   * Note: This property must be bound to the context!
   *
   * Returns the value of the <code>checked</code> property.
   * The initial value is <code>false</code>.
   *
   * Determines if the check box is checked.
   *
   * @return      the current value of the checked property
   * @see #setChecked(boolean)
   */
  public boolean getChecked();

  /**
   * Note: This property must be bound to the context!
   *
   * Sets property <code>checked</code> to the new value.
   *
   * @param value     the new value of the checked property
   * @see #getChecked()
   */
  public void setChecked(boolean value);

  /* Bound Property
     Name: readOnly, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the readOnly
   *                property is bound
   */
  public void bindReadOnly(String path);

  /**
   * Binds property <code>readOnly</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       readOnly property is bound
   */
  public void bindReadOnly(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>readOnly</code>.
   *
   * @return        the path of the context attribute to which the readOnly
   *                is currently bound
   */
  public String bindingOfReadOnly();

  /**
   * Returns the value of the <code>readOnly</code> property.
   * The initial value is <code>false</code>.
   *
   * Controls whether the check box may be toggled.
   *
   * @return      the current value of the readOnly property
   * @see #setReadOnly(boolean)
   */
  public boolean getReadOnly();

  /**
   * Sets property <code>readOnly</code> to the new value.
   *
   * @param value     the new value of the readOnly property
   * @see #getReadOnly()
   */
  public void setReadOnly(boolean value);

  /* Bound Property
     Name: state, Visibility: public, Type: State, Initial value: normal
     convertible: false
  */

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the state
   *                property is bound
   */
  public void bindState(String path);

  /**
   * Binds property <code>state</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       state property is bound
   */
  public void bindState(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>state</code>.
   *
   * @return        the path of the context attribute to which the state
   *                is currently bound
   */
  public String bindingOfState();

  /**
   * Returns the value of the <code>state</code> property.
   * The initial value is <code>WDState.NORMAL</code>.
   *
   * The state of the check box.
   *
   * @return      the current value of the state property
   * @see #setState(WDState)
   */
  public WDState getState();

  /**
   * Sets property <code>state</code> to the new value.
   *
   * @param value     the new value of the state property
   * @see #getState()
   */
  public void setState(WDState value);

  /* Bound Property
     Name: text, Visibility: public, Type: TranslatableText
     convertible: true
  */

  /**
   * Binds property <code>text</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the text
   *                property is bound
   */
  public void bindText(String path);

  /**
   * Binds property <code>text</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       text property is bound
   */
  public void bindText(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>text</code>.
   *
   * @return        the path of the context attribute to which the text
   *                is currently bound
   */
  public String bindingOfText();

  /**
   * Returns the value of the <code>text</code> property.
   * The initial value is <code>""</code>.
   *
   * The text displayed in the check box.
   *
   * @return      the current value of the text property
   * @see #setText(String)
   */
  public String getText();

  /**
   * Sets property <code>text</code> to the new value.
   *
   * @param value     the new value of the text property
   * @see #getText()
   */
  public void setText(String value);

  /* Bound Property
     Name: textDirection, Visibility: public, Type: TextDirection, Initial value: inherit
     convertible: false
  */

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the textDirection
   *                property is bound
   */
  public void bindTextDirection(String path);

  /**
   * Binds property <code>textDirection</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       textDirection property is bound
   */
  public void bindTextDirection(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>textDirection</code>.
   *
   * @return        the path of the context attribute to which the textDirection
   *                is currently bound
   */
  public String bindingOfTextDirection();

  /**
   * Returns the value of the <code>textDirection</code> property.
   * The initial value is <code>WDTextDirection.INHERIT</code>.
   *
   * Determines the direction of displayed text.
   *
   * @return      the current value of the textDirection property
   * @see #setTextDirection(WDTextDirection)
   */
  public WDTextDirection getTextDirection();

  /**
   * Sets property <code>textDirection</code> to the new value.
   *
   * @param value     the new value of the textDirection property
   * @see #getTextDirection()
   */
  public void setTextDirection(WDTextDirection value);

//@@begin extensions
//@@end

}
