
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/standard/api/IWDAbstractDropDownByIndex.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.standard.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro AbstractDropDownByIndex API.
 *
 * Abstract base class of drop-down list classes with index based context binding.
 * Represents a one-from-many selection visualized by a text field, a button and a drop-down list.
 * The selected value is displayed in the text field, the list of all selectable values is displayed
 * in the drop-down list which appears when the button is pressed.
 * <p>
 * <strong>Data binding:</strong>
 * <br>
 * The displayed texts and the selection are retrieved from a context.
 * The context must provide a node <code>X</code> with <code>X.cardinality = 0..n</code> with an attribute
 * <code>y</code> of type <code>String</code>.
 * The selectable values are the values of attribute <code>y</code> of the node elements.
 * The selected value is determined by the lead selection of node <code>X</code>.
 * <p>
 * The property <code>texts</code> must be bound to the attribute <code>y</code>.
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDAbstractDropDownByIndex extends IWDAbstractDropDown
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when the selection of the drop-down list box is changed.
   * Event parameter is the zero based index of the new selected value.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>int index - Zero based index of the new selected value.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  

  /* Bound Property
     Name: texts, Visibility: private, Type: String
     convertible: true
  */

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>texts</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the texts
   *                property is bound
   */
  public void bindTexts(String path);

  /**
   * Note: This property must be bound to the context!
   *
   * Binds property <code>texts</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       texts property is bound
   */
  public void bindTexts(IWDAttributeInfo attributeInfo);

  /**
   * Note: This property must be bound to the context!
   *
   * Binding path of property <code>texts</code>.
   *
   * @return        the path of the context attribute to which the texts
   *                is currently bound
   */
  public String bindingOfTexts();

//@@begin extensions
//@@end

}
