
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDPatternTray.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro PatternTray API.
 *
 * Use the PatternTray control to create a Tray like control. It groups a number of UI elements under a common header. The PatternTray can contain a Menu and several PatternExpandFunction elements (for open/close buttons).
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDPatternContentArea
 * @see IWDPatternExpandFunction
 * @SAPWebDynproPart 2
 */
public interface IWDPatternTray extends IWDAbstractPatternContainer
{
  
  /**
   * Default value of property <code>title</code>.
   */
  public static final String DEFAULT_TITLE = "";

  /* Bound Property
     Name: title, Visibility: public, Type: TranslatableText
     convertible: true
  */

  /**
   * Binds property <code>title</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the title
   *                property is bound
   */
  public void bindTitle(String path);

  /**
   * Binds property <code>title</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       title property is bound
   */
  public void bindTitle(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>title</code>.
   *
   * @return        the path of the context attribute to which the title
   *                is currently bound
   */
  public String bindingOfTitle();

  /**
   * Returns the value of the <code>title</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the header text of a PatternTitle container.
   *
   * @return      the current value of the title property
   * @see #setTitle(String)
   */
  public String getTitle();

  /**
   * Sets property <code>title</code> to the new value.
   *
   * @param value     the new value of the title property
   * @see #getTitle()
   */
  public void setTitle(String value);

  /* outgoing aggregation:
     Name=PatternTray.Items, isAbstract=false
Role A: Name=Items, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternTray, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Item at the end of the list of Items.
   *
   * @param aPatternContentArea     the Item to be added into the list
   * @see #getItems()
   */
  public void addItem(IWDPatternContentArea aPatternContentArea);

  /**
   * Adds the given Item at the specified index in the list of Items.
   *
   * @param aPatternContentArea     the Item to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getItems()
   */
  public void addItem(IWDPatternContentArea aPatternContentArea, int index);

  /**
   * Swaps the Items at the given indices.
   * 
   * @param i index of the first Item to swap
   * @param j index of the second Item to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapItems(int i, int j); 
   
  /**
   * Returns the list of Items.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Items
   */
  public IWDPatternContentArea[] getItems();

  /**
   * Returns the Item at the given index.
   *
   * @return Item at the given index
   */
  public IWDPatternContentArea getItem(int index);

  /**
   * Returns the index of the given element in the list of Items
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfItem(IWDPatternContentArea aPatternContentArea);
       
  /**
   * Returns the number of Items.
   * 
   * @return the current number of Items.
   * @see #getItems()
   */
  public int numberOfItems();
  
  /**
   * Checks if there exist Items.
   *
   * @return      <code>true</code> if there are Items;
   *              <code>false</code> otherwise.
   * @see #getItems()
   */
  public boolean hasItems();

  /**
   * Returns an iterator over the list of Items.
   *
   * @return      an iterator over the current Items
   * @see #getItems()
   */
  public Iterator iterateItems();

  /**
   * Removes the entry at the given index from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public IWDPatternContentArea removeItem(int index);

  /**
   * Removes the entry with the given ID from the list of Items.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public IWDPatternContentArea removeItem(String id);

  /**
   * Removes all entries from the list of Items.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addItem(IWDPatternContentArea)
   * @see #getItems()
   */
  public void removeAllItems(); 

  /**
   * Destroys all entries in the list of Items.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllItems();

//@@begin extensions
//@@end

}
