
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDPatternSequence.java#3 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.services.event.api.IWDParameterMapping;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro PatternSequence API.
 *
 * PatternSequence is used to display a sequence of data organized in steps.
 * Use it, for example, for creating a wizard. One step at a time may be selected
 * and its content by displayed. A step is selected by clicking its title. If not all steps can be displayed scrolling between the tabs is possible.  The PatternSequence can contains a Menu and several PatternExpandFunction (for open/close buttons).
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDPatternExpandFunction
 * @see IWDPatternSequenceStep
 * @SAPWebDynproPart 2
 */
public interface IWDPatternSequence extends IWDAbstractPatternContainer
{

  // Event "onSelect"
  
  /**
   * Returns the action to which the event <code>onSelect</code> is mapped.
   *
   * The action performed when a step is selected.
   * Event parameter is the ID of the selected step.
   *
   * @return the action to which the event is mapped
   * @see #mappingOfOnSelect()
   */
  public IWDAction getOnSelect();

  /**
   * Maps the event <code>onSelect</code> to the given action.
   *
   * @param action  the action for the event
   * @see #getOnSelect()
   */
  public void setOnSelect(IWDAction action);
  
  /**
   * Returns the parameter mapping of event <code>onSelect</code>.
   *
   * <p>To be accessible in a view controller, a UI element event parameter
   * has to be mapped to a controller event handler parameter. This is done
   * by defining a parameter mapping.</p>
   * 
   * <b>Event parameters:</b>
   * <ul>
   * <li>String step - The ID of the selected PatternSequenceStep.</li>
   * </ul>
   *
   * @return parameter mapping list.
   * @see #getOnSelect()
   */  
  public IWDParameterMapping mappingOfOnSelect();
  
  
  /**
   * Default value of property <code>maxVisibleSteps</code>.
   */
  public static final int DEFAULT_MAX_VISIBLE_STEPS = 7;
  
  /**
   * Default value of property <code>selectedStep</code>.
   */
  public static final String DEFAULT_SELECTED_STEP = "";

  /* Bound Property
     Name: maxVisibleSteps, Visibility: public, Type: Integer, Initial value: 7
     convertible: false
  */

  /**
   * Binds property <code>maxVisibleSteps</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the maxVisibleSteps
   *                property is bound
   */
  public void bindMaxVisibleSteps(String path);

  /**
   * Binds property <code>maxVisibleSteps</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       maxVisibleSteps property is bound
   */
  public void bindMaxVisibleSteps(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>maxVisibleSteps</code>.
   *
   * @return        the path of the context attribute to which the maxVisibleSteps
   *                is currently bound
   */
  public String bindingOfMaxVisibleSteps();

  /**
   * Returns the value of the <code>maxVisibleSteps</code> property.
   * The initial value is <code>7</code>.
   *
   * Sets the maximum number of visible items for the PatternSequenceStep control. If the PatternSequence contains more Steps scrolling between Steps is enabled.
   *
   * @return      the current value of the maxVisibleSteps property
   * @see #setMaxVisibleSteps(int)
   */
  public int getMaxVisibleSteps();

  /**
   * Sets property <code>maxVisibleSteps</code> to the new value.
   *
   * @param value     the new value of the maxVisibleSteps property
   * @see #getMaxVisibleSteps()
   */
  public void setMaxVisibleSteps(int value);

  /* Bound Property
     Name: selectedStep, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>selectedStep</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the selectedStep
   *                property is bound
   */
  public void bindSelectedStep(String path);

  /**
   * Binds property <code>selectedStep</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       selectedStep property is bound
   */
  public void bindSelectedStep(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>selectedStep</code>.
   *
   * @return        the path of the context attribute to which the selectedStep
   *                is currently bound
   */
  public String bindingOfSelectedStep();

  /**
   * Returns the value of the <code>selectedStep</code> property.
   * The initial value is <code>""</code>.
   *
   * Contains the ID of the currently selected PatternSequenceStep.
   *
   * @return      the current value of the selectedStep property
   * @see #setSelectedStep(String)
   */
  public String getSelectedStep();

  /**
   * Sets property <code>selectedStep</code> to the new value.
   *
   * @param value     the new value of the selectedStep property
   * @see #getSelectedStep()
   */
  public void setSelectedStep(String value);

  /* outgoing aggregation:
     Name=PatternSequence.Steps, isAbstract=false
Role A: Name=Steps, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternSequence, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Step at the end of the list of Steps.
   *
   * @param aPatternSequenceStep     the Step to be added into the list
   * @see #getSteps()
   */
  public void addStep(IWDPatternSequenceStep aPatternSequenceStep);

  /**
   * Adds the given Step at the specified index in the list of Steps.
   *
   * @param aPatternSequenceStep     the Step to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getSteps()
   */
  public void addStep(IWDPatternSequenceStep aPatternSequenceStep, int index);

  /**
   * Swaps the Steps at the given indices.
   * 
   * @param i index of the first Step to swap
   * @param j index of the second Step to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapSteps(int i, int j); 
   
  /**
   * Returns the list of Steps.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      an array containing references to the current Steps
   */
  public IWDPatternSequenceStep[] getSteps();

  /**
   * Returns the Step at the given index.
   *
   * @return Step at the given index
   */
  public IWDPatternSequenceStep getStep(int index);

  /**
   * Returns the index of the given element in the list of Steps
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfStep(IWDPatternSequenceStep aPatternSequenceStep);
       
  /**
   * Returns the number of Steps.
   * 
   * @return the current number of Steps.
   * @see #getSteps()
   */
  public int numberOfSteps();
  
  /**
   * Checks if there exist Steps.
   *
   * @return      <code>true</code> if there are Steps;
   *              <code>false</code> otherwise.
   * @see #getSteps()
   */
  public boolean hasSteps();

  /**
   * Returns an iterator over the list of Steps.
   *
   * @return      an iterator over the current Steps
   * @see #getSteps()
   */
  public Iterator iterateSteps();

  /**
   * Removes the entry at the given index from the list of Steps.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addStep(IWDPatternSequenceStep)
   * @see #getSteps()
   */
  public IWDPatternSequenceStep removeStep(int index);

  /**
   * Removes the entry with the given ID from the list of Steps.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addStep(IWDPatternSequenceStep)
   * @see #getSteps()
   */
  public IWDPatternSequenceStep removeStep(String id);

  /**
   * Removes all entries from the list of Steps.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addStep(IWDPatternSequenceStep)
   * @see #getSteps()
   */
  public void removeAllSteps(); 

  /**
   * Destroys all entries in the list of Steps.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllSteps();

  /* outgoing aggregation:
     Name=PatternSequence.Title, isAbstract=false
Role A: Name=Title, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=PatternSequence, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Title instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current Title
   * @see #setTitle(IWDPatternSequenceStep)
   */
  public IWDPatternSequenceStep getTitle();

  /**
   * Sets the Title instance.
   *
   * @param title    the new title
   * @see #getTitle()
   */
  public void setTitle(IWDPatternSequenceStep title);

  /**
   * Destroys the Title instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyTitle();

//@@begin extensions
//@@end

}
