
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/uielib/pattern/api/IWDPatternContentArea.java#2 $
//@@end

package com.sap.tc.webdynpro.clientserver.uielib.pattern.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.clientserver.uielib.pattern.api.*; // Pattern
import com.sap.tc.webdynpro.progmodel.api.*; // Core
import com.sap.tc.webdynpro.clientserver.uielib.standard.api.*; // Standard
//@@begin imports
//@@end

/**
 * Web Dynpro PatternContentArea API.
 *
 * Determines the content item of a pattern container. The content item could either a UIElement or a ToolBar. If a ToolBar and UIElement is specified only the UiElement is rendered!
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDPatternContentArea extends IWDViewElement
{
  
  /**
   * Default value of property <code>border</code>.
   */
  public static final boolean DEFAULT_BORDER = false;
  
  /**
   * Default value of property <code>design</code>.
   */
  public static final WDPatternContainerDesign DEFAULT_DESIGN = WDPatternContainerDesign.PLAIN;
  
  /**
   * Default value of property <code>hasContentPadding</code>.
   */
  public static final boolean DEFAULT_HAS_CONTENT_PADDING = true;
  
  /**
   * Default value of property <code>horizontalScrollingMode</code>.
   */
  public static final WDUnidirectionalScrollingMode DEFAULT_HORIZONTAL_SCROLLING_MODE = WDUnidirectionalScrollingMode.NONE;
  
  /**
   * Default value of property <code>visible</code>.
   */
  public static final WDVisibility DEFAULT_VISIBLE = WDVisibility.VISIBLE;

  /* Bound Property
     Name: border, Visibility: public, Type: Boolean, Initial value: false
     convertible: false
  */

  /**
   * Binds property <code>border</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the border
   *                property is bound
   */
  public void bindBorder(String path);

  /**
   * Binds property <code>border</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       border property is bound
   */
  public void bindBorder(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>border</code>.
   *
   * @return        the path of the context attribute to which the border
   *                is currently bound
   */
  public String bindingOfBorder();

  /**
   * Returns the value of the <code>border</code> property.
   * The initial value is <code>false</code>.
   *
   * Determines whether the PatternContentArea control has a border or not.
   *
   * @return      the current value of the border property
   * @see #setBorder(boolean)
   */
  public boolean getBorder();

  /**
   * Sets property <code>border</code> to the new value.
   *
   * @param value     the new value of the border property
   * @see #getBorder()
   */
  public void setBorder(boolean value);

  /* Bound Property
     Name: design, Visibility: public, Type: PatternContainerDesign, Initial value: plain
     convertible: false
  */

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the design
   *                property is bound
   */
  public void bindDesign(String path);

  /**
   * Binds property <code>design</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       design property is bound
   */
  public void bindDesign(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>design</code>.
   *
   * @return        the path of the context attribute to which the design
   *                is currently bound
   */
  public String bindingOfDesign();

  /**
   * Returns the value of the <code>design</code> property.
   * The initial value is <code>WDPatternContainerDesign.PLAIN</code>.
   *
   * Specifies the design for the PatternContentArea control.
   * For the parameter values see enumeration 'PatternContainerDesign'.
   *
   * @return      the current value of the design property
   * @see #setDesign(WDPatternContainerDesign)
   */
  public WDPatternContainerDesign getDesign();

  /**
   * Sets property <code>design</code> to the new value.
   *
   * @param value     the new value of the design property
   * @see #getDesign()
   */
  public void setDesign(WDPatternContainerDesign value);

  /* Bound Property
     Name: hasContentPadding, Visibility: public, Type: Boolean, Initial value: true
     convertible: false
  */

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the hasContentPadding
   *                property is bound
   */
  public void bindHasContentPadding(String path);

  /**
   * Binds property <code>hasContentPadding</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       hasContentPadding property is bound
   */
  public void bindHasContentPadding(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>hasContentPadding</code>.
   *
   * @return        the path of the context attribute to which the hasContentPadding
   *                is currently bound
   */
  public String bindingOfHasContentPadding();

  /**
   * Returns the value of the <code>hasContentPadding</code> property.
   * The initial value is <code>true</code>.
   *
   * Determineswhether the PatternContentArea control has content padding or not.
   *
   * @return      the current value of the hasContentPadding property
   * @see #setHasContentPadding(boolean)
   */
  public boolean getHasContentPadding();

  /**
   * Sets property <code>hasContentPadding</code> to the new value.
   *
   * @param value     the new value of the hasContentPadding property
   * @see #getHasContentPadding()
   */
  public void setHasContentPadding(boolean value);

  /* Bound Property
     Name: horizontalScrollingMode, Visibility: public, Type: UnidirectionalScrollingMode, Initial value: none
     convertible: false
  */

  /**
   * Binds property <code>horizontalScrollingMode</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the horizontalScrollingMode
   *                property is bound
   */
  public void bindHorizontalScrollingMode(String path);

  /**
   * Binds property <code>horizontalScrollingMode</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       horizontalScrollingMode property is bound
   */
  public void bindHorizontalScrollingMode(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>horizontalScrollingMode</code>.
   *
   * @return        the path of the context attribute to which the horizontalScrollingMode
   *                is currently bound
   */
  public String bindingOfHorizontalScrollingMode();

  /**
   * Returns the value of the <code>horizontalScrollingMode</code> property.
   * The initial value is <code>WDUnidirectionalScrollingMode.NONE</code>.
   *
   * This specifies the type of horizontal scrolling which occurs in the PatternContentArea. The default value is NONE which shows all content regardless of width. SHOW turns on the scrollbars (both vertical and horizontal) for the control, regardless of whether the control's content exceeds the available width. AUTO turns scrollbars on only if the width of the content exceeds the available width of the parent window.
   *
   * @return      the current value of the horizontalScrollingMode property
   * @see #setHorizontalScrollingMode(WDUnidirectionalScrollingMode)
   */
  public WDUnidirectionalScrollingMode getHorizontalScrollingMode();

  /**
   * Sets property <code>horizontalScrollingMode</code> to the new value.
   *
   * @param value     the new value of the horizontalScrollingMode property
   * @see #getHorizontalScrollingMode()
   */
  public void setHorizontalScrollingMode(WDUnidirectionalScrollingMode value);

  /* Bound Property
     Name: visible, Visibility: public, Type: Visibility, Initial value: visible
     convertible: false
  */

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the visible
   *                property is bound
   */
  public void bindVisible(String path);

  /**
   * Binds property <code>visible</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       visible property is bound
   */
  public void bindVisible(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>visible</code>.
   *
   * @return        the path of the context attribute to which the visible
   *                is currently bound
   */
  public String bindingOfVisible();

  /**
   * Returns the value of the <code>visible</code> property.
   * The initial value is <code>WDVisibility.VISIBLE</code>.
   *
   * Determines if this PatternContentArea is visible or not.
   *
   * @return      the current value of the visible property
   * @see #setVisible(WDVisibility)
   */
  public WDVisibility getVisible();

  /**
   * Sets property <code>visible</code> to the new value.
   *
   * @param value     the new value of the visible property
   * @see #getVisible()
   */
  public void setVisible(WDVisibility value);

  /* outgoing aggregation:
     Name=PatternContentArea.Content, isAbstract=false
Role A: Name=Content, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=PatternContentArea, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Content instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current Content
   * @see #setContent(IWDUIElement)
   */
  public IWDUIElement getContent();

  /**
   * Sets the Content instance.
   *
   * @param content    the new content
   * @see #getContent()
   */
  public void setContent(IWDUIElement content);

  /**
   * Destroys the Content instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyContent();

  /* outgoing aggregation:
     Name=PatternContentArea.ToolBar, isAbstract=false
Role A: Name=ToolBar, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=PatternContentArea, Navigable=false, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the ToolBar instance.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current ToolBar
   * @see #setToolBar(IWDToolBar)
   */
  public IWDToolBar getToolBar();

  /**
   * Sets the ToolBar instance.
   *
   * @param toolBar    the new toolBar
   * @see #getToolBar()
   */
  public void setToolBar(IWDToolBar toolBar);

  /**
   * Destroys the ToolBar instance.
   * Destroyed elements do not exist any longer, i.e. a new element may be
   * created with the same ID.
   */
  public void destroyToolBar();

  /* incoming aggregation:
     Name=PatternTray.Items, isAbstract=false
Role A: Name=Items, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=PatternTray, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Returns the current PatternTray.
   *
   * <!-- no documentation from UML model -->
   *
   * @return      the current PatternTray
   */
  public IWDPatternTray getPatternTray();

//@@begin extensions
//@@end

}
