package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

/**
 * A helper class of the IWDGeoRouter. A stop is a geo position that must be part 
 * of the route, i.e. the start, end or a stop in the middle of the route.
 * Stops consist of a geo position, an id and a description.
 * @author SAP
 */
public class WDGeoRouterStop
{
  private String id;
  private String description;
  private WDGeoPosition position;

  public WDGeoRouterStop(String id, String description, WDGeoPosition position)
  {
    this.id = id;
    this.description = description;
    this.position = position;
  }
  
  public String getId()
  {
    return id;
  }
  
  public String getDescription()
  {
    return description;
  }
  
  public WDGeoPosition getGeoPosition()
  {
    return position;
  }

  public String toString()
  {
    return "stop id:" + id + " description:" + description + " position:" + position;
  }
}
