package com.sap.tc.webdynpro.clientserver.uielib.graphics.api;

import java.net.URL;
import java.util.List;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDConverter
{
  /**
   * Set the URL of the IGS that provides the conversoin services 
   */
  public void setIgsUrl(URL igsURL);
  
  /**
   * Sets the width of the converted file (image).
   * This property is optional.
   */
  public void setWidth(int width);
  
  /**
   * Sets the height of the converted file (image).
   * This property is optional.
   */
  public void setHeight(int height);

  /**
   * Sets the url of the file that is to be converted.
   * This property is mandatory.
   */
  public void setSourceUrlString(String sourceUrl);

  /**
   * Sets the format of the file that is to be converted
   * This property is mandatory.
   */
  public void setInputFormat(WDConverterInputFormat inputFormat);
  
  /**
   * Sets the format of the converted file
   * This property is mandatory.
   */
  public void setOutputFormat(WDConverterOutputFormat outputFormat);
  
  /**
   * Triggers an igs call. Throws an exception if call was not successful.
   */
  public void execute() throws WDException;
  
  /**
   * Clears all conversion settings and results.
   */
  public void clear();
  /**
   * Returns a list of all conversion result ids.
   */
  public List getResultIds() throws WDException;
  
  /**
   * Returns the matching output format of the converted file. 
   */
  public WDConverterOutputFormat getOutputFormat(String id) throws WDException;
  
  /**
   * Returns the matching output format of the converted file. 
   */
  public WDConverterOutputFormat getOutputFormat() throws WDException;
  
  /**
   * Returns the raw data of the matching converted image.
   */
  public byte[] getImageAsByteArray(String id) throws WDException;
  
  /**
   * Returns the raw data of the converted image.
   */
  public byte[] getImageAsByteArray() throws WDException;
  
  /**
   * Returns a url string to the matching converted image in the Web Dynpro cache.
   */
  public String getImageUrlString(String id) throws WDException;
  
  /**
   * Returns a url string to the converted image in the Web Dynpro cache.
   */
  public String getImageUrlString() throws WDException;
}
