package com.sap.tc.webdynpro.clientserver.session;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/session/WDSessionExpiredException.java#2 $
 */
 
 /**
 * Exception thrwon if session id is no longer valid (most probably due to session expiration)
 *
 * @deprecated This class is not part of the Web Dynpro API and might be withdrawn
 *    with the first new NetWeaver release in 2006. It is not reasonable for applications 
 *    to explicitly catch this subclass of WDRuntimeException.
 * 
 * @author SAP
 * @SAPWebDynproPart 5
 */
public class WDSessionExpiredException extends WDRuntimeException {
  /**
   * Creates a web dynpro exception
   */
  public WDSessionExpiredException(String messageText) {
    super(messageText);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDSessionExpiredException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDSessionExpiredException(Throwable reason) {
    super(reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDSessionExpiredException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }
  
  /**
   * Creates a web dynpro exception
   */
  public WDSessionExpiredException() {
    super("Session has expired!");
  }  

}
