/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/portal/WDPortalWorkProtectMode.java#2 $
 */
package com.sap.tc.webdynpro.clientserver.portal;

import com.sap.tc.webdynpro.clientserver.cal.ClientApplication;
import com.sap.tc.webdynpro.clientserver.task.Task;
import com.sap.tc.webdynpro.services.cal.core.ClientConstants;

/**
 * Class WDPortalWorkProtectMode allows to control the Work Protect Mode
 * when running within SAP Portal
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPortalWorkProtectMode {
  

  /**
   * Constructor 
   */
  private WDPortalWorkProtectMode() {
  }
  
  /**
   * Method setApplicationDirty.
   * @param b
   */
  public static void setApplicationDirty(boolean b){
    ((ClientApplication) Task.getCurrentTask().getApplication()).setApplicationDirty(b);
    Task.getCurrentTask().getClientInfoObject().setItem(ClientConstants.APPLICATION_IS_DIRTY_STATE, String.valueOf(b));
  }
  
  /**
   * Method setApplicationDirtyControl.
   * @param mode
   */
  public static void setApplicationDirtyControl(WDApplicationIsDirtyMode mode){
    ((ClientApplication) Task.getCurrentTask().getApplication()).setApplicationDirtyControl(mode);
    Task.getCurrentTask().getClientInfoObject().setItem(ClientConstants.APPLICATION_DIRTY_CONTROL, mode.getMode());  
  }

}
