/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/portal/WDPortalUtils.java#5 $
 */
package com.sap.tc.webdynpro.clientserver.portal;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.tc.webdynpro.services.api.WDHelperFactory;

/**
 * <code>WDPortalUtils</code> contains some helper functions for the portal environment.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPortalUtils {

  /** package local since also used by class WDPortalWorkProtectMode */
  static IWDPortalUtils instance = (IWDPortalUtils) WDHelperFactory.getInstance(IWDPortalUtils.class);

  /**
   * Constructor 
   */
  private WDPortalUtils() {
  }

  /**
   * Checks whether or not the Web Dynpro application is running the the portal environment or not.
   * 
   * @return TRUE if the Web Dynpro application is running in the portal environment and FALSE otherwise.
   * @return
   */
  public static boolean isRunningInPortal() {
    return instance.isRunningInPortal();
  }

  /**
   * Returns a reference to the specified portal service or NULL if this service could not be found.
   * 
   * @param serviceName the name of the portal service
   * @return a reference to the specified portal service of NULL if this servcie could not be found.
   */
  public static Object lookup(String serviceName) {

    Hashtable environment = new Hashtable();
    environment.put(Context.INITIAL_CONTEXT_FACTORY, "com.sapportals.portal.prt.registry.PortalRegistryFactory");

    try {
      //get an instance of the service
      InitialContext ic = new InitialContext(environment);
      return ic.lookup("broker/services/" + serviceName);
    } catch (Exception e) {
      // $JL-EXC$ suppress JLin exception check
      return null;
    }
  }

  /**
   * Returns a instance of the specified portal service or NULL if this service could not be found. For the JNDI lookup 
   * to get a service instance the used environment contains one key <code>Context.INITIAL_CONTEXT_FACTORY</code>
   * with value <code>"com.sapportals.portal.prt.registry.PortalRegistryFactory"</code>.
   * 
   * @param serviceName the full-qualfied name of the portal service
   * @return a instance of  the specified portal service of NULL if this service could not be found.
   */
  public static Object getServiceReference(String serviceName) {
    return instance.getServiceReference(serviceName);
  }

  /**
   * Returns a instance of the specified portal service or NULL if this service could not be found.
   * 
   * @param serviceName the full-qualfied name of the portal service
   * @param environment the used environment for the JNDI lookup to get the instance of the specified portal service
   * @return a instance of  the specified portal service of NULL if this service could not be found.
   */
  public static Object getServiceReference(String serviceName, Hashtable environment) {
    return instance.getServiceReference(serviceName, environment);
  }

  public interface IWDPortalUtils {
    boolean isRunningInPortal();
    void setApplicationDirty(boolean b);
    void setApplicationDirtyControl(WDApplicationIsDirtyMode mode);
    public Object getServiceReference(String serviceName, Hashtable environment);
    public Object getServiceReference(String serviceName);
  }
}
