/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/portal/WDApplicationIsDirtyMode.java#1 $
 */
package com.sap.tc.webdynpro.clientserver.portal;

/**
 * Class WDApplicationIsDirtyMode can be used to define whether an application and/or the
 * client is allowed to declare an application dirty
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDApplicationIsDirtyMode {
  /** only application itself is allowed to set an application dirty */
   public static final WDApplicationIsDirtyMode APPLICATION_ONLY; 

   /** default: client and application can decide whether an application is dirty */
   public static final WDApplicationIsDirtyMode STANDARD; 

  /** default: client and application can decide whether an application is dirty */
   public static final WDApplicationIsDirtyMode NONE;
   
   static{
     NONE = new WDApplicationIsDirtyMode(0);
     STANDARD = new WDApplicationIsDirtyMode(1);
     APPLICATION_ONLY = new WDApplicationIsDirtyMode(2);     
   }

  /** mode */   
  protected final int mode;
    
  /**
   * Constructor 
   */
  protected WDApplicationIsDirtyMode(int mode) {
    this.mode = mode;
  }

  /**
   * Method getMode.
   * @return
   */
  public String getMode() {
    return String.valueOf(mode);
  }

}
