/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/navigation/api/WDPortalNavigationMode.java#1 $
 */
package com.sap.tc.webdynpro.clientserver.navigation.api;

/**
 * <code>WDPortalNavigationMode</code> describes the possible start modes for a portal navigation.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPortalNavigationMode  {

	/**
	 * Parameter defining the launching of the navigation node will be performed in the same window.
	 */
	public static final WDPortalNavigationMode SHOW_INPLACE = new WDPortalNavigationMode("0");

	/**
	 * Parameter defining the launching of the navigation node will be 
	 * performed in an external (new) STANDALONE window (iView/Page only)
	 */
	public static final WDPortalNavigationMode SHOW_EXTERNAL = new WDPortalNavigationMode("1");  
	
	/**
	 * Parameter defining the launching of the navigation node
	 * will be performed in an external (new) PORTAL window.
	 */
	public static final WDPortalNavigationMode SHOW_EXTERNAL_PORTAL = new WDPortalNavigationMode("2");

	/**
	 * Parameter defining the launching of the navigation node will be
	 *  performed in an external (new) EXECUTION window  (thin portal window).
	 */
	//public static final WDPortalNavigationMode SHOW_EXTERNAL_EXECUTION = new WDPortalNavigationMode("3");
		
  private String value;
  
	private WDPortalNavigationMode (String value) {
    this.value = value;  
	}
  
  public String toString() {
    return value;  
  }
}
