/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/navigation/api/WDPortalNavigationHistoryMode.java#1 $
 */
package com.sap.tc.webdynpro.clientserver.navigation.api;

/**
 * <code>WDPortalNavigationMode</code> defines the possible history modes for a portal navigation.
 * 
 *  @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPortalNavigationHistoryMode {
	
	/**
	 * Parameter defines that the navigation entry is visible in the history and duplicate entries are allowed.
	 */
	public static final WDPortalNavigationHistoryMode ALLOW_DUPLICATIONS = new WDPortalNavigationHistoryMode ("0");
	
	/**
	 * Parameter defines that the navigation entry is visible in the history. Duplicate entries are NOT allowed.
	 */
	public static final WDPortalNavigationHistoryMode NO_DUPLICATIONS = new WDPortalNavigationHistoryMode ("1");
	
	/**
	 * Parameter defines that the navigation entry is NOT visible in the history.
	 */
	public static final WDPortalNavigationHistoryMode NO_HISTORY = new WDPortalNavigationHistoryMode ("2");
	
	private String value;
  
	private WDPortalNavigationHistoryMode (String value) {
		this.value = value;  
	}
  
	public String toString() {
		return value;  
	}
}
