/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_clientserver/java/com/sap/tc/webdynpro/clientserver/event/api/WDPortalEventing.java#1 $
 */

package com.sap.tc.webdynpro.clientserver.event.api;

import com.sap.tc.webdynpro.progmodel.api.IWDAction;
import com.sap.tc.webdynpro.progmodel.controller.Action;
import com.sap.tc.webdynpro.services.event.RaisePortalEvent;
import com.sap.tc.webdynpro.services.event.SubscribePortalEvent;
import com.sap.tc.webdynpro.services.event.UnSubscribePortalEvent;
import com.sap.tc.webdynpro.services.task.TaskBinder;

/**
 * <code>WDPortalEventing</code> provides access to portal eventing functionality.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPortalEventing {

  private WDPortalEventing () {    
  }

  /**
   * Subscribe to the defined portal event. The portal event is mapped to the specified Web Dynpro action.
   * If the defined view gets the portal event, the event handler of the action is called.
   * 
   * @param nameSpace the name space of the portal event
   * @param event     the name of the portal event
   * @param action    the associated Web Dynpro action
   */ 
  public static void subscribe (String nameSpace, String event, IWDAction action) {
    
    SubscribePortalEvent subscribeEvent 
      = new SubscribePortalEvent (nameSpace, 
                                  event,
                                  ((Action)action).getControllerInternal().getComponentInternal().getId(),
                                  action.getController().getName(),
                                  ((Action) action).getName());
                                  
    TaskBinder.getCurrentTask().getUpdateClientPeer().sendEvent(subscribeEvent);  
  }
  
 /**
   * Unsubscribe for the defined portal event. 
   * 
   * @param nameSpace the name space of the portal event
   * @param event     the name of the portal event
   * @param action    the associated Web Dynpro action
   */ 
  public static void unsubscribe (String nameSpace, String event, IWDAction action) {
  
    UnSubscribePortalEvent unsubscribeEvent 
      = new UnSubscribePortalEvent (nameSpace, 
                                    event,
                                    ((Action)action).getControllerInternal().getComponentInternal().getId(),
                                    action.getController().getName());
                                  
    TaskBinder.getCurrentTask().getUpdateClientPeer().sendEvent(unsubscribeEvent);  
  }

 /**
   * Raise the specied portal event.
   * 
   * @param nameSpace the name space of the portal event
   * @param event     the name of the portal event
   * @param parameter the event parameter 
   */   
  public static void fire (String nameSpace, String event, String parameter) {
  
    RaisePortalEvent raiseEvent 
      = new RaisePortalEvent (nameSpace,
                              event, 
                              parameter);
             
    TaskBinder.getCurrentTask().getUpdateClientPeer().sendEvent(raiseEvent);
  }  

}
