#*******************************************************************************
# Copyright (c) 2000, 2003 IBM Corporation and others.
# All rights reserved. This program and the accompanying materials 
# are made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
# 
# Contributors:
#     IBM Corporation - initial API and implementation
#     Kevin Cornell (Rational Software Corporation)
#*******************************************************************************

# Makefile for creating the eclipse unicode launcher program.

# This script expects the following environment variables set:
#
# PROGRAM_OUTPUT - the filename of the output executable
# PROGRAM_NAME - the title of the splash screen

!include <ntwin32.mak>

# Define the object modules to be compiled and flags.
OBJS   = eclipse.obj eclipseWin.obj eclipseUtil.obj aeclipse.obj aeclipseWin.obj aeclipseUtil.obj
LIBS   = kernel32.lib user32.lib gdi32.lib
LFLAGS = /INCREMENTAL:NO /NOLOGO -subsystem:windows,4.0 -entry:wmainCRTStartup
RES    = eclipse.res
EXEC   = eclipse.exe
DEBUG  = #$(cdebug)
wcflags = -DPROGRAM_NAME=L\"$(PROGRAM_NAME)\" \
	-DDEFAULT_OS=L"\"$(DEFAULT_OS)\"" \
	-DDEFAULT_OS_ARCH=L"\"$(DEFAULT_OS_ARCH)\"" \
	-DDEFAULT_WS=L"\"$(DEFAULT_WS)\"" \
	$(cflags)
acflags = -I..\.. -DPROGRAM_NAME=\"$(PROGRAM_NAME)\" \
	-DDEFAULT_OS="\"$(DEFAULT_OS)\"" \
	-DDEFAULT_OS_ARCH="\"$(DEFAULT_OS_ARCH)\"" \
	-DDEFAULT_WS="\"$(DEFAULT_WS)\"" \
	$(cflags)

all: $(EXEC)

eclipse.obj:
    $(cc) $(DEBUG) $(wcflags) $(cvars) /Fo$*.obj eclipse.c

eclipseUtil.obj:
    $(cc) $(DEBUG) $(wcflags) $(cvars) /Fo$*.obj eclipseUtil.c

eclipseWin.obj:
    $(cc) $(DEBUG) $(wcflags) $(cvars) /Fo$*.obj eclipseWin.c

aeclipse.obj:
    $(cc) $(DEBUG) $(acflags) $(cvars) /Foaeclipse.obj ..\..\eclipse.c

aeclipseUtil.obj:
    $(cc) $(DEBUG) $(acflags) $(cvars) /FoaeclipseUtil.obj ..\..\eclipseUtil.c

aeclipseWin.obj:
    $(cc) $(DEBUG) $(acflags) $(cvars) /FoaeclipseWin.obj ..\eclipseWin.c

$(EXEC): $(OBJS) $(RES)
    $(link) $(LFLAGS) -out:$(PROGRAM_OUTPUT) $(OBJS) $(RES) $(LIBS)

$(RES): ..\eclipse.rc
    $(rc) -r -fo $(RES) ..\eclipse.rc
    
clean:
	del $(OBJS) $(RES) *.exe
