/*                                                                                   :q
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Hashtable;

import org.apache.xerces.util.XMLChar;

/**
 * NMTOKEN datatype validator.
 *
 * @version $Id: NMTOKENDatatypeValidator.java,v 1.2 2002/01/29 01:15:11 lehors Exp $
 */
public class NMTOKENDatatypeValidator 
    extends AbstractDatatypeValidator {

   public  NMTOKENDatatypeValidator() throws InvalidDatatypeFacetException{
        // Native, No Facets defined, Restriction
      this( null, null, false );

   }

   public NMTOKENDatatypeValidator( DatatypeValidator base, Hashtable facets, 
                                    boolean derivedByList ) throws InvalidDatatypeFacetException {
       // ignore everything -- just do NMTOKEN validation
   }

   /**
    * validate that a string is a W3C string type
    * 
    * @param content A string containing the content to be validated
    * @param list
    * @exception throws InvalidDatatypeException if the content is
    *                   not a W3C string type
    * @exception InvalidDatatypeValueException
    */
   public void validate(String content, Object state)  
        throws InvalidDatatypeValueException {
       if (!XMLChar.isValidNmtoken(content)) {
           throw new InvalidDatatypeValueException(content+" is not a NMTOKEN");
       }
   }

   public Hashtable getFacets() { return null; }

   public int compare( String content, String facetValue){
       return content.compareTo(facetValue);
   }

   public Object clone() throws CloneNotSupportedException  {
      return this;
   }

} // class NMTOKENDatatypeValidator
