/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2000-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.xerces.impl.dtd;

import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.Grammar;

/*
 * All information specific to dTD grammars.  
 * 
 * @author Neil Graham, IBM
 * @version $Id: XMLDTDDescription.java,v 1.1 2002/01/17 23:54:59 neilg Exp $
 */

public class XMLDTDDescription implements XMLGrammarDescription {

    // Data

    // basic information required by XMLGrammarDescription
    protected String fBaseURI = null;
    protected String fLiteralSystemId = null;
    protected String fExpandedSystemId = null;
    protected String fPublicId = null;

    // pieces of information needed to make this usable as a Grammar key
    protected String fRootName = null;
    protected String fInternalSubset = null;

    // XMLGrammarDescription methods

    public String getPublicId() {
        return fPublicId;
    } // getPublicId():  String

    // get base URI against wihch literal systemId is expanded
    public String getBaseSystemId () {
        return fBaseURI;
    } // getBaseSystemId():  String

    // get expanded systemId
    public String getExpandedSystemId () {
        return fExpandedSystemId;
    } // getExpandedSystemId():  String

    // get systemId as found in entity decl
    public String getLiteralSystemId () {
        return fLiteralSystemId;
    } // getLiteralSystemId():  String

    public String getGrammarType () {
        return Grammar.XML_DTD;
    } // getGrammarType():  String

    // return the root name of this DTD
    public String getRootName() {
        return fRootName;
    } // getRootName():  String

    // return the internal subset.  Entities should not be expanded;
    // this is simply the raw string representation of the stuff
    // between [ and ]>
    public String getInternalSubset () {
        return fInternalSubset;
    } // getInternalSubset():  String
} // class XMLDTDDescription

