/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.mimehandler;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.service.IService;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

import java.util.Locale;

/**
 * This service provides informations about mime types. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @author Jens Kaiser
 * @version $Id:$
 */
public interface IMimeHandlerService extends IService {

  /**
   * Returns a mime type for the given extension. If the extension is unknown a
   * default mime type will be returned (application/octet-stream)
   *
   * @param extension TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception WcmException Exception raised in failure situation
   */
  IMime get(String extension)
    throws WcmException;


  /**
   * Returns a mime type for the given mime type string representation. If the
   * mime type is unknown a default mime type will be returned
   * (application/octet-stream)
   *
   * @param mime TBD: Description of the incoming method parameter
   * @return mime
   * @exception WcmException Exception raised in failure situation
   */
  IMime getMime(String mime)
    throws WcmException;

  /**
   * Returns a mime type for the given resource. If the resource extension is
   * unknown a default mime type will be returned (application/octet-stream)
   *
   * @param resource TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception WcmException Exception raised in failure situation
   */
  IMime get(IResource resource)
    throws WcmException;


  /**
   * Returns a mime type for the given RID. If the RID's extension is unknown a
   * default mime type will be returned (application/octet-stream)
   *
   * @param rid TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception WcmException Exception raised in failure situation
   */
  IMime get(RID rid)
    throws WcmException;


  /**
   * Returns all registered mime types. Returns an empty array if no mime types
   * were registered.
   *
   * @return mimetypes
   * @exception WcmException Exception raised in failure situation
   */
  IMime[] getMimetypes()
    throws WcmException;


  /**
   * This method returns the extensions for a given mime type (or an empty array
   * if there are no extensions for the given mime type)
   *
   * @param mimetype TBD: Description of the incoming method parameter
   * @return extensionsForMimetype
   * @deprecated as of NW04. Use IMime#getExtensions() instead.
   */
  String[] getExtensionsForMimetype(String mimetype);


  /**
   * This method returns the mime type for a given extension
   *
   * @param extension TBD: Description of the incoming method parameter
   * @return mimetypeForExtension
   * @deprecated as of NW04. Use #get(String) instead.
   */
  String getMimetypeForExtension(String extension);


  /**
   * This method returns the mime type for a given URI
   *
   * @param uri TBD: Description of the incoming method parameter
   * @return mimetypeForURI
   * @deprecated as of NW04. Use #get(RID)instead
   */
  String getMimetypeForURI(URI uri);


  /**
   * Get the MimetypeForRid attribute of the IMimeHandlerService object.
   *
   * @param rid TBD: Description of the incoming method parameter
   * @return mimetypeForRid
   * @deprecated as of NW04. Use #get(RID) instead
   */
  String getMimetypeForRid(RID rid);


  /**
   * This method returns the image (icon) for a given mime type
   *
   * @param mime TBD: Description of the incoming method parameter
   * @return image
   * @deprecated as of NW04. Use IMime#getImage instead.
   */
  String getImage(String mime);


  /**
   * Get the Image attribute of the IMimeHandlerService object.
   *
   * @param resource TBD: Description of the incoming method parameter
   * @return image
   * @deprecated as of NW04. Use IMime#getImage instead
   */
  String getImage(IResource resource);


  /**
   * Get the ImagePath attribute of the IMimeHandlerService object.
   *
   * @param mime TBD: Description of the incoming method parameter
   * @return imagePath
   * @deprecated as of NW04. Use IMime#getImagePath instead
   */
  String getImagePath(String mime);


  /**
   * Get the ImagePath attribute of the IMimeHandlerService object.
   *
   * @param resource TBD: Description of the incoming method parameter
   * @return imagePath
   * @deprecated as of NW04. Use IMime#getImagePath instead
   */
  String getImagePath(IResource resource);


  /**
   * This method returns the description for a given mime type
   *
   * @param mime TBD: Description of the incoming method parameter
   * @return description
   * @deprecated as of NW04. Use IMime#getDescription(String) instead.
   */
  String getDescription(String mime);


  /**
   * this method returns the description for a given mime type
   *
   * @param mime TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @return description
   * @deprecated as of NW04. Use IMime#getDescription(String,Locale) instead.
   */
  String getDescription(String mime, Locale locale);
}
