/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.mimehandler;

import java.util.Locale;

/**
 * Container for mime types. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @author Jens Kaiser
 * @version $Id:$
 */
public interface IMime {

  /**
   * Returns the mime type representatiom
   *
   * @return The mime type
   */
  String getType();


  /**
   * This method returns the image (icon)
   *
   * @return image
   */
  String getImage();


  /**
   * Returns the path to the image (icon)
   *
   * @return The the path to the image (icon)
   */
  String getImagePath();


  /**
   * Returns the default extension for this mime type or <code>null</code> if no
   * default extension is set.
   *
   * @return The default extension for this mime type
   */
  String getDefaultExtension();


  /**
   * Returns all extensions for this mime type
   *
   * @return All extensions assigned to this mime type
   */
  String[] getExtensions();


  /**
   * The description for this mime type
   *
   * @return description
   */
  String getDescription();


  /**
   * The description for this mime type
   *
   * @param locale locale
   * @return description
   */
  String getDescription(Locale locale);
}
