/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.ViewHelper.ServletViewHelper;
import java.util.Iterator;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
public class Controller extends HttpServlet {
	public String getServletInfo() {
		return "Servlet description";
	}

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		super.service(request, response);

		/* Comment by Together
		
				response.setContentType("text/html");
				PrintWriter out = new PrintWriter(response.getOutputStream());
				//
				//Write your code here
				//
				out.println("<HTML>");
				out.println("<HEAD><TITLE>Controller Output</TITLE>");
				out.println("</HEAD>");
				out.println("<BODY>");
				//
				//Write your HTML here
				//
				out.println("</BODY>");
				out.println("</HTML>");
				out.flush();
			*/
	}

	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page)
		throws javax.servlet.ServletException, java.io.IOException {
		RequestDispatcher dispatcher =
			getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request, response);
	}

	protected void processRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		String title = STRATEGY;
		ApplicationResources resource = ApplicationResources.getInstance();
		try {
			response.setContentType(CONTENT_TYPE);
			java.io.PrintWriter out = response.getWriter();
			out.println("<html><title>" + title + "</title>");
			out.println("<body>");
			out.println("<h2><center>Employees List</h2>");
			EmployeeDelegate delegate = new EmployeeDelegate();

			/**
			 *ApplicationResources provides a simple API for retrieving constants and other preconfigured values*
			 */
			Iterator employees =
				delegate.getEmployees(
					ApplicationResources.getInstance().getAllDepartments());
			out.println("<table border=2>");
			out.println("<tr><th>Information</th></tr>");
			while (employees.hasNext()) {
				out.println("<tr>");
				Employee emp = (Employee) employees.next();
				out.println("<td>" + emp.getSameInformation() + "</td>");
				out.println("</tr>");
			}
			out.println("</table>");
			out.println("<br><br>");
			out.println("</body>");
			out.println("</html>");
			out.close();
		} catch (Exception e) {
			LogManager.logMessage(
				"Handle this exception appropriately",
				e.getMessage());
			request.setAttribute(resource.getMessageAttr(), e.getMessage());
			dispatch(request, response, resource.getErrorPage(e));
		}
	}

	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	private final static String STRATEGY = "Servlet View Strategy";
	private final static String CONTENT_TYPE = "text/html";

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet View Strategy
	 * @supplierRole ServletViewStrategyLink
	 */
	/*# private LogManager _logManager; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet View Strategy
	 * @supplierRole ServletViewStrategyLink
	 */
	/*# private ApplicationResources _applicationResources; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet View Strategy
	 * @supplierRole ServletViewStrategyLink
	 */
	/*# private EmployeeDelegate _employeeDelegate; */
}

