/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.InterceptingFilter.TemplateFilter;
import java.io.IOException;

public abstract class TemplateFilter implements javax.servlet.Filter {
	private javax.servlet.FilterConfig filterConfig;

	public void setFilterConfig(javax.servlet.FilterConfig fc) {
		filterConfig = fc;
	}

	public javax.servlet.FilterConfig getFilterConfig() {
		return filterConfig;
	}

	public void doFilter(
		javax.servlet.ServletRequest request,
		javax.servlet.ServletResponse response,
		javax.servlet.FilterChain chain)
		throws IOException, javax.servlet.ServletException {
		// Common processing for all filters can go here
		doPreProcessing(request, response, chain);
		// Common processing for all filters can go here
		doMainProcessing(request, response, chain);
		// Common processing for all filters can go here
		doPostProcessing(request, response, chain);
		// Common processing for all filters can go here */
		// Pass control to the next filter in the chain or
		// to the target resource
		chain.doFilter(request, response);
	}

	public void doPreProcessing(
		javax.servlet.ServletRequest request,
		javax.servlet.ServletResponse response,
		javax.servlet.FilterChain chain) {
	}

	public void doPostProcessing(
		javax.servlet.ServletRequest request,
		javax.servlet.ServletResponse response,
		javax.servlet.FilterChain chain) {
	}

	public abstract void doMainProcessing(
		javax.servlet.ServletRequest request,
		javax.servlet.ServletResponse response,
		javax.servlet.FilterChain chain);
}

