/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.FrontController.ServletFront;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Controller extends HttpServlet {
	public String getServletInfo() {
		return "Servlet description";
	}

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		super.service(request, response);

		/* Comment by Together
		
				response.setContentType("text/html");
				PrintWriter out = new PrintWriter(response.getOutputStream());
				//
				//Write your code here
				//
				out.println("<HTML>");
				out.println("<HEAD><TITLE>Controller Output</TITLE>");
				out.println("</HEAD>");
				out.println("<BODY>");
				//
				//Write your HTML here
				//
				out.println("</BODY>");
				out.println("</HTML>");
				out.flush();
			*/
	}

	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page)
		throws javax.servlet.ServletException, java.io.IOException {
		RequestDispatcher dispatcher =
			getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request, response);
	}

	protected void processRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		String page;
		ApplicationResources resource = ApplicationResources.getInstance();
		try {
			RequestHelper helper = new RequestHelper(request);
			Command cmdHelper = helper.getCommand();
			page = cmdHelper.execute(request, response);
		} catch (Exception e) {
			LogManager.logMessage(e.getMessage());
			request.setAttribute(resource.getMessageAttr(), e.getMessage());
			page = resource.getErrorPage(e);
		}
		dispatch(request, response, page);
	}

	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet Front Strategy
	 * @supplierRole ServletFrontStrategyLink
	 */

	/*# private LogManager _logManager; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet Front Strategy
	 * @supplierRole ServletFrontStrategyLink
	 */

	/*# private ApplicationResources _applicationResources; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Servlet Front Strategy
	 * @supplierRole ServletFrontStrategyLink
	 */

	/*# private RequestHelper _requestHelper; */
}

