/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.FrontController.FilterController;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Controller extends HttpServlet {
	public String getServletInfo() {
		return "Servlet description";
	}

	public void service(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		try {
			processRequest(request, response);
		} catch (Exception e) {
		}
		super.service(request, response);

		/* Comment by Together
		
				response.setContentType("text/html");
				PrintWriter out = new PrintWriter(response.getOutputStream());
				//
				//Write your code here
				//
				out.println("<HTML>");
				out.println("<HEAD><TITLE>Controller Output</TITLE>");
				out.println("</HEAD>");
				out.println("<BODY>");
				//
				//Write your HTML here
				//
				out.println("</BODY>");
				out.println("</HTML>");
				out.flush();
			*/
	}

	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page)
		throws javax.servlet.ServletException, java.io.IOException {
		RequestDispatcher dispatcher =
			getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request, response);
	}

	protected void processRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		String page;
		ApplicationResources resource = ApplicationResources.getInstance();
		try {
			ServletFilterManager filterManager = new ServletFilterManager();
			page = filterManager.processFilter(request, response);
		} catch (Exception e) {
			LogManager.logMessage(e.getMessage());
			request.setAttribute(resource.getMessageAttr(), e.getMessage());
			page = resource.getErrorPage(e);
		}
		if (page != null && page.length() > 0)
			dispatch(request, response, page);
	}

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Filter Controller Strategy
	 * @supplierRole FilterControllerStrategyLink
	 */

	/*# private LogManager _logManager; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Filter Controller Strategy
	 * @supplierRole FilterControllerStrategyLink
	 */

	/*# private ApplicationResources _applicationResources; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Filter Controller Strategy
	 * @supplierRole FilterControllerStrategyLink
	 */

	/*# private ServletFilterManager _servletFilterManager; */
}

