/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.FrontController.BaseFrontStartegy;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Controller extends HttpServlet {
	public String getServletInfo() {
		return "Servlet description";
	}

	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page)
		throws javax.servlet.ServletException, java.io.IOException {
		RequestDispatcher dispatcher =
			getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request, response);
	}

	protected void processRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		String page;
		ApplicationResources resource = ApplicationResources.getInstance();
		try {
			RequestHelper helper = new RequestHelper(request);
			Command cmdHelper = helper.getCommand();
			page = cmdHelper.execute(request, response);
		} catch (Exception e) {
			LogManager.logMessage(e.getMessage());
			request.setAttribute(resource.getMessageAttr(), e.getMessage());
			page = resource.getErrorPage(e);
		}
		dispatch(request, response, page);
	}

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Base Front Strategy
	 * @supplierRole BaseFrontStrategyLink
	 */

	/*# private LogManager _logManager; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Base Front Strategy
	 * @supplierRole BaseFrontStrategyLink
	 */

	/*# private ApplicationResources _applicationResources; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Base Front Strategy
	 * @supplierRole BaseFrontStrategyLink
	 */

	/*# private RequestHelper _requestHelper; */
}

