/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Presentation.CompositeView.ServletView;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Controller extends HttpServlet {
	public String getServletInfo() {
		return "Servlet description";
	}

	protected void include(
		HttpServletRequest request,
		HttpServletResponse response,
		String page)
		throws javax.servlet.ServletException, java.io.IOException {
		RequestDispatcher dispatcher =
			getServletContext().getRequestDispatcher(page);
		dispatcher.include(request, response);
	}

	protected void processRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		String title = "Composite View Servlet Strategy";
		try {
			ViewManager viewManager = new ViewManager();
			response.setContentType("text/html");
			java.io.PrintWriter out = response.getWriter();
			out.println("<html><title>" + title + "</title>");
			out.println("<body>");
			out.println("<h2><center>Include sample</h2>");
			out.println("<br><br>");
			include(request, response, viewManager.getIncludePage(request));
			out.println("<br><br>");
			out.println("</body></html>");
			out.close();
		} catch (Exception e) {
			LogManager.logMessage(e.getMessage());
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	public void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws javax.servlet.ServletException, java.io.IOException {
		processRequest(request, response);
	}

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Composite Servlet View Strategy
	 * @supplierRole CompositeServletViewLink
	 */

	/*# private LogManager _logManager; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Composite Servlet View Strategy
	 * @supplierRole CompositeServletViewLink
	 */

	/*# private ViewManager _viewManager; */
}

